package org.gcube.data.spd.irmng;


import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.model.Taxon;


public class Utils {

	//	final static String urlDump = "http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip";
	static GCUBELog logger = new GCUBELog(Utils.class);

	/**
	 * Get taxonomy by id
	 */
	public static Taxon createTaxonomy(String id) {
		Taxon t = null;
		ResultSet results = null;
		Database database = null; 
		String id_parent;
		//		logger.trace("id_record " + id_record);
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship from taxon where taxonid = '" + id_record + "'");
			results = database.get("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship from taxon where taxonid = '" + id + "'");

			if(results.next()) {	        	

				id_parent = results.getString(1);
				//				logger.trace("idParent " + id_parent);

				t = new Taxon(id+"");
				t.setScientificName(results.getString(2));
				t.setRank(results.getString(3));

				t.setCitation(results.getString(4));     
				if  (id_parent != null)        				
					t.setParent(createTaxonomy(id_parent));	
				else
					t.setParent(null);

				results.close();
			}
			
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		} finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("sql Error",e);
			}
			database.shutDown();
		}

		return t;
	}

	/**
	 * Get date
	 */
	public static Calendar getCalendar(String date1) {

		//		SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
		Calendar cal = null;
		Date date = DateUtil.getInstance().parse(date1);
		//						d = DateUtil.getInstance().parse(modified);
		if (date != null){
			cal=Calendar.getInstance();
			cal.setTime(new Date(date.getTime()));
		}	
		//		else
		//			logger.warn("Unknown data format");

		return cal;
	}

	/**
	 * Set scientific name without author
	 */
	public static String setScName(String id, String rank) {
		//		logger.trace("id " + id + " rank " + rank);
		String scientificName = "";		
		if(rank!=null){
			if (rank.equals("family"))
				scientificName = getScientifiName(id, "family");
			else if (rank.equals("genus"))
				scientificName = getScientifiName(id, "genus");
			else if (rank.equals("species"))
				scientificName = getScientifiName(id, "genus") + " "+ getScientifiName(id, "specificepithet");
			else
				scientificName = getScientifiName(id, "scientificname");
		}
		return scientificName;
	}


	/**
	 * Get scientific name without author
	 */
	private static String getScientifiName(String id, String rank) {

		String scientificName = "";
		ResultSet results = null;
		Database database = null; 

		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select " + rank + " from taxon where taxonid = '" + id + "'");
			results = database.get("select " + rank + " from taxon where taxonid = '" + id + "'");

			if(results.next()) {	        	
				scientificName = results.getString(1);	
			}
			results.close();
		}catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		} finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("sql Error",e);
			}
			database.shutDown();
		}
		return scientificName;

	}

}

