package org.gcube.data.spd.irmng;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.StarRecord;
import org.gbif.dwc.text.UnsupportedArchiveException;
import org.gcube.common.core.utils.logging.GCUBELog;

class UpdateThread extends Thread {

	static GCUBELog logger = new GCUBELog(UpdateThread.class);

	UpdateThread() {
		super("Thread");
		start(); // Start the thread
	}

	// update db every month (30 days)
	public void run() {
		logger.trace("Irmng DB will be updated in 30 days from now");
		while (true) {		
			try {
				update();
				sleep(2592000000L);				
			} catch (InterruptedException e) {
				logger.error("InterruptedException", e);
			}
		}
	} 


	/**
	 * Download DwC-A file and open it
	 */
	protected void update(){
		try {
			URL url = new URL(IrmngPlugin.dumpUrl);
			File tempFolder = File.createTempFile("irmng-folder", "" );			
			tempFolder.delete();
			tempFolder.mkdir();	
			logger.trace(tempFolder);
			if (downloadFromUrl(url, tempFolder + "/IRMNG_DWC.zip")) {
				openArch(tempFolder);				
			}
					
//			File tempFolder = new File("/tmp/irmng-folder1167277303984002580");			
//			openArch(tempFolder);
			
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Download dump DB from URL http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip
	 */
	public boolean downloadFromUrl(URL url, String string) throws IOException {

		logger.trace("down");
		boolean flag = false;
		logger.trace("Downloading " + string);
		InputStream is = null;
		FileOutputStream fos = null;

		try {
			URLConnection urlConn = url.openConnection();

			is = urlConn.getInputStream();
			fos = new FileOutputStream(string);

			byte[] buffer = new byte[4096];
			int len;

			while ((len = is.read(buffer)) > 0) {
				fos.write(buffer, 0, len);
			}
			flag = true;

		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} finally {
				if (fos != null) {
					fos.close();
				}
			}
		}
		return flag;
	}

	/**
	 * Open DwC-A and read info
	 */
	protected void openArch(File tempFolder){
		try {
			logger.trace(tempFolder);
			Archive arch = ArchiveFactory.openArchive(new File(tempFolder + "/IRMNG_DWC.zip"), tempFolder);
			//			Archive arch = ArchiveFactory.openArchive(tempFolder);

			if (!arch.getCore().hasTerm(DwcTerm.scientificName)){
				logger.trace("This application requires dwc-a with scientific names");
				System.exit(1);
			}
			Database database = null;  
			database = new Database();  			
			database.connect();
			// loop over core darwin core records
			Iterator<StarRecord> iter = arch.iterator();
			StarRecord dwc;
			String stmt = null;
			ResultSet result = null;
			ArrayList<String> terms = new ArrayList<String>();

			while(iter.hasNext()){
				dwc = iter.next();
//				logger.trace("id " + dwc.core().id());

				terms.add(dwc.core().id());
				terms.add(dwc.core().value(DwcTerm.scientificName));
				terms.add(dwc.core().value(DwcTerm.scientificNameAuthorship));
				terms.add(dwc.core().value(DwcTerm.genus));
				terms.add(dwc.core().value(DwcTerm.specificEpithet));
				terms.add(dwc.core().value(DwcTerm.family));
				terms.add(dwc.core().value(DwcTerm.taxonRank));
				terms.add(dwc.core().value(DwcTerm.taxonomicStatus));
				terms.add(dwc.core().value(DwcTerm.nomenclaturalStatus));
				terms.add(dwc.core().value(DwcTerm.nameAccordingTo));
				terms.add(dwc.core().value(DwcTerm.originalNameUsageID));
				terms.add(dwc.core().value(DwcTerm.namePublishedIn));
				terms.add(dwc.core().value(DwcTerm.acceptedNameUsageID));
				terms.add(dwc.core().value(DwcTerm.parentNameUsage));
				terms.add(dwc.core().value(DwcTerm.parentNameUsageID));
				terms.add(dwc.core().value(DwcTerm.taxonRemarks));
				terms.add(dwc.core().value(DcTerm.modified));
				terms.add(dwc.core().value(DwcTerm.nomenclaturalCode));

				//				for (Record extRecord : dwc.extension(GbifTerm.SpeciesProfile.qualifiedName())){
				//					if (!database.update("insert into speciesprofile (taxon_id, isextinct, ismarine) values ('" + dwc.core().id() + "', '" + extRecord.value(GbifTerm.isExtinct) + "', '" + extRecord.value(GbifTerm.isMarine) + "')"))
				//						logger.trace("insert into speciesprofile (taxon_id, isextinct, ismarine) values ('" + dwc.core().id() + "', '" + extRecord.value(GbifTerm.isExtinct) + "', '" + extRecord.value(GbifTerm.isMarine) + "')");
				//				}

				result = database.get("select count(*) from taxon where taxonid = '" + dwc.core().id() + "'");
//				logger.trace("select count(*) from taxon where taxonid = '" + dwc.core().id() + "'");
				if (result.next()) {
					//if the row exists, update, else insert
					if (result.getInt(1) == 0)
						stmt = ("insert into taxon (taxonid, scientificname, scientificnameauthorship, genus, specificepithet, family, taxonrank, taxonomicstatus, nomenclaturalstatus, nameaccordingto, originalnameusageid, namepublishedin, acceptednameusageid, parentnameusage, parentnameusageid, taxonremarks, modified, nomenclaturalcode) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
					else
						stmt = ("update taxon set taxonid = ?, scientificname = ?, scientificnameauthorship = ?, genus = ?, specificepithet = ?, family = ?, taxonrank = ?, taxonomicstatus = ?, nomenclaturalstatus = ?, nameaccordingto = ?, originalnameusageid = ?, namepublishedin = ?, acceptednameusageid = ?, parentnameusage = ?, parentnameusageid = ?, taxonremarks = ?, modified = ?, nomenclaturalcode = ? where taxonid ='" + dwc.core().id() + "'");

					if (!database.preStatement(stmt, terms)){
						logger.trace("error");
					}
					terms.clear();
				}	
				result.close();
			}
			
			logger.trace("completed!");
			database.shutDown();
		} catch (UnsupportedArchiveException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}


}


/**
 * Create floraDB thread
 */
class CreateDBThread extends Thread {

	static GCUBELog logger = new GCUBELog(Utils.class);

	CreateDBThread() {

		super("Thread");
		start(); // Start the thread
	}

	public void run() {

		try {
			logger.trace("Create tables...");
			if (createDB())
				logger.trace("Done.");
		} catch (IOException e) {
			logger.error("IO Error", e);
		} catch (SQLException e) {
			logger.error("sql Error", e);
		}
	} 

	/**
	 * Metod called by CreateDBThread
	 */
	public static boolean createDB() throws SQLException, IOException {

		Database database = null;  
		try {
			database = new Database();  			
			if (database.connect()){

				BufferedReader br = new BufferedReader(new InputStreamReader(IrmngPlugin.class.getResourceAsStream(IrmngPlugin.dumpDb)));
				String line;
				while ((line = br.readLine()) != null) {

					boolean updateQuery = database.update(line);	
					if (!updateQuery) {
						logger.trace("Error executing : " + line);
						return false;
					}
				}
			}
		} finally {	
			database.shutDown();
		}
		return true;

	}
}

