package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus.Status;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl extends ClassificationCapability {


	GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}


	@Override
	public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {

		List<TaxonomyItem> list = new ArrayList<TaxonomyItem>(); 
		logger.trace("retrieveTaxonChildsByTaxonId " + id_parent);

		ResultSet results = null;
		Database database = null;  

		try {
			database = new Database();  			
			database.connect();

			logger.trace("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where parentnameusageid = '" + id_parent + "'");
			results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where parentnameusageid = '" + id_parent + "'");

			while(results.next()) {	

				TaxonomyItem item = createTaxonomyItem(results);
				list.add(item);
			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		}
		return list;
	}


	/**
	 * Get taxonomy by id
	 */
	protected TaxonomyItem createTaxonomyItemById(String id) {
		TaxonomyItem item = null;
		ResultSet results = null;
		Database database = null; 
		//		logger.trace("id_record " + id_record);
		try {
			database = new Database();  			
			database.connect();
			//						logger.trace("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid from taxon where taxonid = '" + id_record + "'");
			results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where taxonid = '" + id + "'");

			if(results.next()) {	        	
				item = createTaxonomyItem(results);
			}
			else{					
				logger.trace("id " + id + " not in IRMNG");
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		} finally{
			try {
				if (results!=null)
					results.close();
			} catch (SQLException e) {
				logger.error("sql Error",e);
			}
			database.shutDown();
		}

		return item;
	}


	/**
	 * Set status in Result Item
	 */
	private TaxonomyStatus setTaxStatus(String status, String syn_parent) {

		TaxonomyStatus tax = null;
		if ( status!= null){
			if (status.equals("accepted"))
				tax = new TaxonomyStatus("accepted", Status.ACCEPTED);
			else if (status.equals("valid"))
				tax = new TaxonomyStatus("valid", Status.VALID);
			else if (status.equals("synonym"))
				tax = new TaxonomyStatus(Status.SYNONYM, syn_parent, "synonym");
			else
				tax = new TaxonomyStatus(status, Status.UNKNOWN);
		} 
		else
			tax = new TaxonomyStatus(status, Status.UNKNOWN);
		//		else
		//			tax = new TaxonomyStatus(Status.UNKNOWN);
		return tax;
	}






	@Override
	public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property... arg2) {
	}

	@Override
	public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property... arg2) {

		logger.trace("searchByScientificName " + scientificName);

		ResultSet results = null;
		Database database = null;  

		try {
			database = new Database();  			
			database.connect();
			results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");

			while(results.next()) {	

				TaxonomyItem item = createTaxonomyItem(results);
				writer.put(item);

			}
		}catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		}finally{
			if (results!=null)
				try {
					results.close();
				} catch (SQLException e) {
					logger.error("sql Error",e);
				}
			database.shutDown();					

			writer.close();	
		}

	}

	@Override
	public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
		try{
			while(ids.hasNext()) {
				String id = ids.next(); 
				logger.trace("retrieveTaxonById " + id);
				TaxonomyItem item = createTaxonomyItemById(id);
				writer.put(item);
			}
		} catch (Exception e) {
			logger.error("ExceptionPrintStackTrace",e);
		} finally{
			writer.close();	
		}
	}



	private TaxonomyItem createTaxonomyItem(ResultSet result) throws SQLException {

		String id = result.getString(1);
//		logger.trace(id);
		String rank = result.getString(2);
		String citation = result.getString(3);
		String status = result.getString(4);
		Calendar  modified = Utils.getCalendar(result.getString(5));		

		String  syn_parent = result.getString(6);
		String  id_parent = result.getString(7);

		TaxonomyItem item = new TaxonomyItem(id);
		item.setScientificName(Utils.setScName(id, rank));
		item.setCitation(citation);				
		item.setRank(rank);

		item.setStatus(setTaxStatus(status, syn_parent));
		item.setModified(modified);

		//parent null
		if  (id_parent != null){   
			item.setParent(createTaxonomyItemById(id_parent));	
		}
		else
			item.setParent(null);


		return item;
	}


	@Override
	public void getSynonymnsByIds(ObjectWriter<TaxonomyItem> writer,
			String... ids) throws MethodNotSupportedException {

		try{
			for (int i = 0; i < ids.length; i++) 	{
				Iterator<String> iterator = getSynonimnsById(ids[i]); 	
				retrieveTaxonByIds(iterator, writer);
			}
		} finally{
			writer.close();
		}
	}



	/**
	 * Get all synonyms by id
	 */
	private Iterator<String> getSynonimnsById(String id) {
		logger.trace("getSynonimnsById " + id);

		ResultSet results = null;
		Database database = null; 
		List<String> ids = new ArrayList<String>();
		Iterator<String> i = null;

		try {
			database = new Database();  			
			database.connect();
			logger.trace("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
			results = database.get("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
			while (results.next()){
				ids.add(results.getString(1));				
			}
			i = ids.iterator(); 
		}		
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{
			database.shutDown();
		}
		return i;
	}

	//	/**
	//	 * Create Result Item synonym by id
	//	 */
	//	public void createRIById(String id, ObjectWriter<TaxonomyItem> writer) {
	//		
	//		logger.trace("createRIById " + id);
	//
	//		ResultSet results = null;
	//		Database database = null;  
	//		String ScName = "";
	//		String rank = "";
	//		String idParent = "";
	//		String citation = "";
	//
	//		try {
	//			database = new Database();  			
	//			database.connect();
	//			//			taxonid, scientificname, scientificnameauthorship, genus, specificepithet, family, taxonrank, taxonomicstatus, nomenclaturalstatus, nameaccordingto, originalnameusageid, namepublishedin, acceptednameusageid, parentnameusage, parentnameusageid, taxonremarks, modified, nomenclaturalcode
	//			results = database.get("select scientificname, taxonrank, parentnameusageid, scientificnameauthorship from taxon where acceptednameusageid = '" + id + "'");
	//
	////					logger.trace("select scientificname, taxonrank, parentnameusageid, scientificnameauthorship from taxon where acceptednameusageid = '" + id + "'");
	//
	//			while(results.next()) {	
	//
	//				ScName = results.getString(1);
	//				rank = results.getString(2);
	//				idParent = results.getString(3);
	//				citation = results.getString(4);
	//
	//				TaxonomyItem item = new TaxonomyItem(id);
	//				item.setScientificName(ScName);
	//				item.setCitation(citation);				
	//				item.setCredits(IrmngPlugin.credits);
	//				item.setRank(rank);
	//
	//				//				logger.trace("idParent " + idParent);
	//				item.setParent(Utils.createTaxonomy(idParent));
	//
	//				writer.put(item);
	//
	//			}
	//		}
	//		catch (SQLException sqlExcept) {        	
	//			logger.error("sql Error", sqlExcept);
	//		}
	//		catch (Throwable e) {
	//			logger.error("general Error", e);
	//		}finally{
	//			try {
	//				results.close();
	//			} catch (SQLException e) {
	//				logger.error("general Error", e);
	//			}
	//
	//			database.shutDown();
	//		}
	//	}


}

