package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus.Status;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl extends ClassificationCapability {


	GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}


	@Override
	public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {

		List<TaxonomyItem> list = new ArrayList<TaxonomyItem>(); 
		logger.trace("retrieveTaxonChildsByTaxonId " + id_parent);

		ResultSet results = null;
		Database database = null;  
		//		String ScName = "";
		String rank = "";
		Calendar modified;
		String status = "";
		String citation = "";
		String syn_parent = "";
		String id = "";

		try {
			database = new Database();  			
			database.connect();
			
			logger.trace("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid from taxon where parentnameusageid = '" + id_parent + "'");
			results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid from taxon where parentnameusageid = '" + id_parent + "'");

			while(results.next()) {	

				//				ScName = results.getString(1);
				rank = results.getString(1);
				citation = results.getString(2);
				status = results.getString(3);
				modified = Utils.getCalendar(results.getString(4));		

				syn_parent = results.getString(5);
				id = results.getString(6);
				TaxonomyItem item = new TaxonomyItem(id);
				item.setScientificName(Utils.setScName(id, rank));
				item.setCitation(citation);	
				item.setRank(rank);

				item.setStatus(setStatusRI(status, syn_parent));
				item.setModified(modified);

				//parent null
				//				if  (id_parent != null){   
				//					item.setParent(createTaxonomy(id_parent));
				//				}
				item.setParent(null);	

				list.add(item);
			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		}finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		}
		return list;
	}


	/**
	 * Get taxonomy by id
	 */
	protected TaxonomyItem createTaxonomy(String id_record) {
		TaxonomyItem t = null;
		ResultSet results = null;
		Database database = null; 
		String id_parent;
		String status = "";
		String syn_parent = "";
		Calendar modified;
		//		logger.trace("id_record " + id_record);
		try {
			database = new Database();  			
			database.connect();
//						logger.trace("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid from taxon where taxonid = '" + id_record + "'");
			results = database.get("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid from taxon where taxonid = '" + id_record + "'");

			if(results.next()) {	        	
				id_parent = results.getString(1);		
				//								logger.trace("padre " + id_parent);

				t = new TaxonomyItem(id_record+"");			
				t.setScientificName(Utils.setScName(id_record, results.getString(3)));
				t.setRank(results.getString(3));
				t.setCitation(results.getString(4));

				syn_parent = results.getString(7);

				status = results.getString(5);
				t.setStatus(setStatusRI(status, syn_parent));

				modified = Utils.getCalendar(results.getString(6));				
				t.setModified(modified);

				if  (id_parent != null){    	
					//logger.trace("idParent " + id_parent);
					t.setParent(createTaxonomy(id_parent));	
				}
				else
					t.setParent(null);

				results.close();
			}
			else{					
				logger.trace("id " + id_record + " not in IRMNG");
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		} finally{
			try {
				results.close();
			} catch (SQLException e) {
				logger.error("sql Error",e);
			}
			database.shutDown();
		}

		return t;
	}


	/**
	 * Set status in Result Item
	 */
	private TaxonomyStatus setStatusRI(String status, String syn_parent) {

		TaxonomyStatus tax = null;
		if ( status!= null){
			if (status.equals("accepted"))
				tax = new TaxonomyStatus("accepted", Status.ACCEPTED);
			else if (status.equals("valid"))
				tax = new TaxonomyStatus("valid", Status.VALID);
			else if (status.equals("synonym"))
				tax = new TaxonomyStatus(Status.SYNONYM, syn_parent, "synonym");
			else
				tax = new TaxonomyStatus(status, Status.UNKNOWN);
		} 
		else
			tax = new TaxonomyStatus(status, Status.UNKNOWN);
		//		else
		//			tax = new TaxonomyStatus(Status.UNKNOWN);
		return tax;
	}






	@Override
	public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property... arg2) {
	}

	@Override
	public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property... arg2) {

		logger.trace("searchByScientificName " + scientificName);

		ResultSet results = null;
		Database database = null;  
		String rank = "";
		Calendar modified;
		String status = "";
		String citation = "";
		String syn_parent = "";
		String id = "";
		String id_parent = "";

		try {
			database = new Database();  			
			database.connect();
			results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid, parentnameusageid from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
			//				logger.trace("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid from taxon where parentnameusageid = '" + id_parent + "'");

			while(results.next()) {	

				//					ScName = results.getString(1);
				rank = results.getString(1);
				citation = results.getString(2);
				status = results.getString(3);
				modified = Utils.getCalendar(results.getString(4));		

				syn_parent = results.getString(5);
				id = results.getString(6);
				id_parent = results.getString(7);

				TaxonomyItem item = new TaxonomyItem(id);
				item.setScientificName(Utils.setScName(id, rank));
				item.setCitation(citation);				
				item.setRank(rank);
				item.setModified(modified);
				
				item.setStatus(setStatusRI(status, syn_parent));
				
				//parent null
				if  (id_parent != null){   
					item.setParent(createTaxonomy(id_parent));	
				}
				writer.put(item);

			}
		} catch (Exception e) {
			logger.error("ExceptionPrintStackTrace",e);
		} finally{
			writer.close();	
		}

	}

	@Override
	public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {

		try{
			while(ids.hasNext()) {
				String id = ids.next(); 
				logger.trace("retrieveTaxonById " + id);
				ResultSet results = null;
				Database database = null;  
				String rank = "";
				Calendar modified;
				String status = "";
				String citation = "";
				String syn_parent = "";
				String id_parent = "";

				try {
					database = new Database();  			
					database.connect();
					results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where taxonid = '" + id + "'");
					//					logger.trace("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where taxonid = '" + id + "'");

					if(results.next()) {	

						//					ScName = results.getString(1);
						rank = results.getString(1);
						citation = results.getString(2);
						status = results.getString(3);
						modified = Utils.getCalendar(results.getString(4));		

						syn_parent = results.getString(5);
						id_parent = results.getString(6);

						TaxonomyItem item = new TaxonomyItem(id);
						item.setScientificName(Utils.setScName(id, rank));
						item.setCitation(citation);				
						item.setRank(rank);

						item.setStatus(setStatusRI(status, syn_parent));
						item.setModified(modified);

						//parent null
						if  (id_parent != null){   
							item.setParent(createTaxonomy(id_parent));	
						}
						writer.put(item);
					}
					else{					
						logger.trace("id " + id + " not in IRMNG");
					}
				}catch (SQLException sqlExcept) {
					logger.error("sql Error",sqlExcept);
				}
			}
		} catch (Exception e) {
			logger.error("ExceptionPrintStackTrace",e);
		} finally{
			writer.close();	
		}
	}




}

