/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        this.logger.trace((Object)"getSynonimnsByIds");
        TaxonomyItem rs = null;
        try {
            rs = this.getSynbyId(id);
            if (rs != null && writer.isAlive()) {
                writer.write((Object)rs);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException("BrazilianFlora", id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem getSynbyId(String id) {
        TaxonomyItem item = null;
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where acceptednameusageid = ?";
            results = pool.selectPrestatement(query, id);
            if (results != null && results.next()) {
                String ScName = results.getString(1);
                String rank = results.getString(2);
                String status = results.getString(3);
                String idParent = results.getString(4);
                String author = results.getString(5);
                String acceptednameusageid = results.getString(6);
                String qualifier = results.getString(7);
                item = this.createTaxonomyItem(id, ScName, rank, status, idParent, author, acceptednameusageid, qualifier, true);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return item;
    }

    private TaxonomyItem createTaxonomyItem(String id, String ScName, String rank, String status, String idParent, String author, String acceptednameusageid, String qualifier, boolean flag) throws SQLException {
        TaxonomyItem item = null;
        try {
            item = new TaxonomyItem(id);
            item.setScientificName(ScName);
            item.setRank(rank);
            item.setScientificNameAuthorship(author);
            item.setStatus(ClassificationCapabilityImpl.setTaxonomicStatus(status, acceptednameusageid, qualifier));
            item.setCitation(Utils.createCitation());
            item.setCredits(Utils.createCredits());
            if (flag && idParent != null) {
                try {
                    item.setParent(this.retrieveTaxonById(idParent));
                }
                catch (IdNotValidException e) {
                    this.logger.error((Object)"Id Not Valid", (Throwable)e);
                }
            } else {
                item.setParent(null);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ID not valid Exception", (Throwable)e);
        }
        return item;
    }

    public static TaxonomyStatus setTaxonomicStatus(String status, String id_syn, String qualifier) {
        TaxonomyStatus t = status == null ? new TaxonomyStatus(qualifier, TaxonomyStatus.Status.UNKNOWN) : (status.equals("Accepted name") ? new TaxonomyStatus(qualifier, TaxonomyStatus.Status.ACCEPTED) : (status.equals("Synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, id_syn, qualifier) : new TaxonomyStatus(qualifier, TaxonomyStatus.Status.UNKNOWN)));
        return t;
    }

    private ResultSet createResultItemChilds(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id, scientific_name, rank, status, citation, acceptednameusageid, qualifier from flora where id_parent = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String name, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        block14: {
            this.logger.trace((Object)("Retrive taxa by name " + name));
            ResultSet results = null;
            try {
                results = this.createResultSet(name);
                if (results == null) break block14;
                while (results.next()) {
                    String id = results.getString(1);
                    String scientificName = results.getString(2);
                    String rank = results.getString(3);
                    String status = results.getString(4);
                    String acceptednameusageid = results.getString(7);
                    String qualifier = results.getString(8);
                    String parent = results.getString(5);
                    String author = results.getString(6);
                    TaxonomyItem tax = this.createTaxonomyItem(id, scientificName, rank, status, parent, author, acceptednameusageid, qualifier, true);
                    if (writer.isAlive() && tax != null) {
                        writer.write((Object)tax);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                writer.write((StreamException)new StreamBlockingException("BrazilianFlora", ""));
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet createResultSet(String scientificName) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select id, scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where UPPER(scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        block10: {
            block7: while (true) {
                try {
                    while (ids.hasNext()) {
                        String id = ids.next();
                        TaxonomyItem item = null;
                        try {
                            item = this.retrieveTaxonById(id);
                            if (item == null) continue block7;
                            if (writer.isAlive() && item != null) {
                                writer.write((Object)item);
                                continue block7;
                            }
                            break block10;
                        }
                        catch (IdNotValidException e) {
                            this.logger.error((Object)"Id Not Valid", (Throwable)e);
                        }
                    }
                    break block10;
                }
                catch (Exception e) {
                    writer.write((StreamException)new StreamBlockingException("BrazilianFlora", ""));
                    break block10;
                }
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        ConnectionPool pool = null;
        ResultSet results = null;
        TaxonomyItem tax = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where id = ?";
            results = pool.selectPrestatement(query, id);
            if (results.next()) {
                String scientificName = results.getString(1);
                String rank = results.getString(2);
                String status = results.getString(3);
                String parent = results.getString(4);
                String author = results.getString(5);
                String acceptednameusageid = results.getString(6);
                String qualifier = results.getString(7);
                tax = this.createTaxonomyItem(id, scientificName, rank, status, parent, author, acceptednameusageid, qualifier, true);
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"Id not valid exception", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String idParent) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> list = null;
        ResultSet results = null;
        try {
            results = this.createResultItemChilds(idParent);
            if (results != null) {
                list = new ArrayList<TaxonomyItem>();
                while (results.next()) {
                    String qualifier;
                    String acceptednameusageid;
                    String author;
                    String status;
                    String rank;
                    String scientific_name;
                    String id = results.getString(1);
                    TaxonomyItem tax = this.createTaxonomyItem(id, scientific_name = results.getString(2), rank = results.getString(3), status = results.getString(4), idParent, author = results.getString(5), acceptednameusageid = results.getString(6), qualifier = results.getString(7), false);
                    if (tax == null) continue;
                    list.add(tax);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql Error", (Throwable)e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return list;
    }
}

