/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.NewThread;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;

class UpdateThread
extends Thread {
    long nextup;
    static GCUBELog logger = new GCUBELog(UpdateThread.class);

    UpdateThread(long update) {
        super("Thread");
        this.nextup = update;
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            logger.trace((Object)this.createLabel(this.nextup));
            try {
                UpdateThread.sleep(this.nextup);
                if (!UpdateThread.upInfo()) continue;
                this.setlastupdate();
                this.nextup = 2592000000L;
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)"General Error", e);
                continue;
            }
            break;
        }
    }

    private String createLabel(long nextup) {
        Date date = new Date();
        String label = "Flora DB will be updated on " + Utils.nextUpdateDate(nextup + date.getTime());
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setlastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Date date = new Date();
            long dt = date.getTime();
            java.sql.Date today = new java.sql.Date(dt);
            String query = "insert into updates (date) values ('" + today + "')";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                logger.trace((Object)"problem setting last update date");
            }
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    public static boolean upInfo() throws SQLException, MalformedURLException, IOException {
        logger.trace((Object)"Update DB in BRAZILIAN-FLORA-PLUGIN");
        try {
            int i;
            ArrayList<ArrayList<String>> list = Utils.discoverPath("http://checklist.florabrasil.net/service/TREE/VERSION/2012/FORMAT/xml/LANG/en/", null, "", null, false);
            int sizeList = list.size();
            logger.trace(list);
            Thread[] threads = new Thread[sizeList];
            for (i = 0; i < sizeList; ++i) {
                logger.trace(list.get(i));
                threads[i] = new NewThread(list.get(i), i);
            }
            for (i = 0; i < sizeList; ++i) {
                try {
                    logger.trace((Object)"join");
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"interrupted join");
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"exc", (Throwable)e);
            logger.trace((Object)"Exception");
            return false;
        }
        return true;
    }
}

