/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.security.Key;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.flora.capabilities.ExpansionCapabilityImpl;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.ExpansionCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class FloraPlugin
extends AbstractPlugin {
    public static String jdbc;
    public static String username;
    public static String password;
    public static String baseurl;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with Lista de Esp\u00e9cies da Flora do Brasil (http://floradobrasil.jbrj.gov.br/)";
    public static final String citation = "Accessed through: Lista de Esp\u00e9cies da Flora do Brasil - Jardim Bot\u00e2nico do Rio de Janeiro at http://floradobrasil.jbrj.gov.br/2012/ on ";
    public static final String dumpDb = "/createFloraDb.sql";
    public static final String tableName = "flora";
    public static final String driver = "org.postgresql.Driver";
    GCUBELog logger = new GCUBELog(FloraPlugin.class);

    public void initialize(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("rest")) {
                baseurl = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
        }
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("rest")) {
                baseurl = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = ap.password();
        }
        super.update(res);
    }

    public String getDescription() {
        return "Brazilian Flora Plugin";
    }

    public String getRepositoryName() {
        return "BrazilianFlora";
    }

    public void shutdown() throws Exception {
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.Synonims);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public ExpansionCapability getSynonymCapability() {
        return new ExpansionCapabilityImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        block16: {
            ResultSet results = null;
            try {
                results = this.createRSNames(word);
                if (results == null) break block16;
                while (results.next()) {
                    String id = results.getString(1);
                    String scientific_name = results.getString(2);
                    String rank = results.getString(3);
                    String idParent = results.getString(4);
                    String author = results.getString(5);
                    ResultItem rs = null;
                    try {
                        rs = this.createResultItem(id, scientific_name, rank, idParent, author);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error retrieving information ", (Throwable)e);
                    }
                    if (writer.isAlive()) {
                        if (rs == null) continue;
                        writer.write((Object)rs);
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
    }

    private ResultSet createRSNames(String scientificName) {
        ResultSet results = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select id, scientific_name, rank, id_parent, citation from flora where UPPER(scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    private ResultItem createResultItem(String id, String ScName, String rank, String idParent, String author) {
        ResultItem item = new ResultItem(id, ScName);
        item.setCitation(Utils.createCitation());
        item.setCredits(Utils.createCredits());
        item.setRank(rank);
        item.setAuthor(author);
        DataSet dataSet = new DataSet("floraid");
        dataSet.setName("Brazilian Flora");
        DataProvider dp = new DataProvider("floraid");
        dp.setName("Brazilian Flora");
        dataSet.setDataProvider(dp);
        item.setDataSet(dataSet);
        if (rank != null && idParent != null) {
            item.setParent(this.findTaxonById(idParent));
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taxon findTaxonById(String id) {
        ResultSet results = null;
        Taxon item = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id_parent, rank, scientific_name, citation from flora where id = ?";
            results = pool.selectPrestatement(query, id);
            if (results.next()) {
                item = new Taxon(id);
                if (results.getString(1) != null) {
                    item.setParent(this.findTaxonById(results.getString(1)));
                }
                item.setRank(results.getString(2));
                item.setScientificName(results.getString(3));
                item.setAuthor(results.getString(4));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
        }
        return item;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://floradobrasil.jbrj.gov.br/2012/imgs/logo_fdb_2012.gif", "http://floradobrasil.jbrj.gov.br/", "The List of Species of Brazilian Flora is a project coordinated by the Botanical Garden of Rio de Janeiro in partnership with the CRIA. CRIA is responsible for the development and maintenance of the information system. The whole process of validation and inclusion of new data is done online by a network of over 400 taxonomists from Brazil and abroad. The online public version was completed in May 2010.");
        return info;
    }
}

