package org.gcube.data.spd.flora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.flora.dbconnection.RSItem;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamBlockingException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus.Status;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl extends ClassificationCapability {

	GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}

	@Override
	public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id)
			throws IdNotValidException, MethodNotSupportedException,
			ExternalRepositoryException {
		logger.trace("getSynonimnsByIds");
		RSItem rs = null;
		try{
			rs = getSynbyId(id);
			if (rs!=null){
				TaxonomyItem item = null;
				try {
					item = createTaxonomyItem(rs, true);
				} catch (SQLException e) {
					logger.error("sql Error", e);
				}
				if ((item!=null) && (writer.isAlive()))
					writer.write(item);

			}
		}catch (Exception e) {
			writer.write(new StreamBlockingException());
		}finally{
			writer.close();
		}
	}

	/**
	 * get RSItem by id
	 */
	private RSItem getSynbyId(String id) {

		RSItem item = null;

		ConnectionPool pool = null;
		ResultSet results = null;
		try {
			pool = ConnectionPool.getConnectionPool();
			String query ="select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from "+ FloraPlugin.tableName + " where acceptednameusageid = ?";			
			results =  pool.selectPrestatement(query, id);	
			if(results!=null) {	
				if(results.next()) {	
					item = new RSItem();
					item.setId(id);
					item.setScientific_name(results.getString(1));
					item.setRank(results.getString(2));
					item.setStatus(results.getString(3));
					item.setParentId(results.getString(4));
					item.setAuthor(results.getString(5));
					item.setAcceptednameusageid(results.getString(6));
					item.setQualifier(results.getString(7));
				}
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);
		}
		finally {
			try {
				if (results != null) {
					results.close();
				}
			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}	
		return item;
	}


	/**
	 * Create Taxonomy Item by RSItem
	 */

	private TaxonomyItem createTaxonomyItem(RSItem results, boolean flag) throws SQLException {
		TaxonomyItem item = null;
		try{
			String id = results.getId();
			String ScName = results.getScientific_name();
			String rank = results.getRank();
			String status = results.getStatus();
			String idParent = results.getParentId();
			String author = results.getAuthor();
			String acceptednameusageid = results.getAcceptednameusageid();
			String qualifier = results.getQualifier();

			item = new TaxonomyItem(id);
			item.setScientificName(ScName);
			item.setRank(rank);
			item.setAuthor(author);
			item.setStatus(setTaxonomicStatus(status, acceptednameusageid, qualifier));

			item.setCitation(Utils.createCitation());
			item.setCredits(Utils.createCredits());

			if ((flag) && (idParent!=null)){
				try {
					item.setParent(retrieveTaxonById(idParent));
				} catch (IdNotValidException e) {
					logger.error("Id Not Valid", e);
				}    
			}
			else
				item.setParent(null);
		}catch (Exception e) {
			logger.error("ID not valid Exception", e);
		}

		return item;
	}




	/**
	 * Set Taxonomic status using "status", "acceptednameusageid", "qualifier"
	 */
	public static TaxonomyStatus setTaxonomicStatus(String status, String id_syn, String qualifier) {
		TaxonomyStatus t;

		if (status==null)
			t =  new TaxonomyStatus(qualifier, Status.UNKNOWN);
		else if (status.equals("Accepted name"))
			t =  new TaxonomyStatus(qualifier, Status.ACCEPTED);
		else if (status.equals("Synonym"))
			t =  new TaxonomyStatus(Status.SYNONYM, id_syn, qualifier);
		else t =  new TaxonomyStatus(qualifier, Status.UNKNOWN);

		return t;
	}


	@Override
	public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
		List<TaxonomyItem> list = null;
		ResultSet results = null;
		try {
			results = createResultItemChilds(id);
			if (results!=null){
				list = new ArrayList<TaxonomyItem>(); 

				while(results.next()) {	
					//					logger.trace(results);
					RSItem item = new RSItem();
					item.setId(results.getString(8));
					item.setScientific_name(results.getString(1));
					item.setRank(results.getString(2));
					item.setStatus(results.getString(3));
					item.setParentId(results.getString(4));
					item.setAuthor(results.getString(5));
					item.setAcceptednameusageid(results.getString(6));
					item.setQualifier(results.getString(7));

					TaxonomyItem tax = createTaxonomyItem(item, false);
					if (tax!=null)
						list.add(tax);
				}
			}
		} catch (SQLException e) {
			logger.error("sql Error", e);
		}finally{
			if (results!=null){
				try {
					results.close();
				} catch (SQLException e) {
					logger.error("general Error", e);
				}
			}
		}
		return list;	
	}

	/**
	 * Return a ResultSet of Children
	 */
	private ResultSet createResultItemChilds(String id) {

		ConnectionPool pool = null;
		ResultSet results = null;
		try {
			pool = ConnectionPool.getConnectionPool();
			String query = "select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier, id from "+ FloraPlugin.tableName + " where id_parent = ?";
			results =  pool.selectPrestatement(query, id);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		}
		return results;

	}

	@Override
	public void searchByCommonName(String arg0,
			ObjectWriter<TaxonomyItem> arg1, Property... arg2) {
	}


	@Override
	public void searchByScientificName(String scientificName,
			ObjectWriter<TaxonomyItem> writer, Property... arg2) {
		logger.trace("Retrive taxa by name " + scientificName);

		ResultSet results = null;
		try {
			results = createResultSet(scientificName);
			if (results!=null){
				while(results.next()) {	

					RSItem item = new RSItem();
					item.setId(results.getString(1));
					item.setScientific_name(results.getString(2));
					item.setRank(results.getString(3));
					item.setStatus(results.getString(4));
					item.setParentId(results.getString(5));
					item.setAuthor(results.getString(6));
					item.setAcceptednameusageid(results.getString(7));
					item.setQualifier(results.getString(8));

					TaxonomyItem tax = createTaxonomyItem(item, true);
					if (writer.isAlive() && (tax!=null))
						writer.write(tax);
					else
						break;
				}
			}

		}catch (Exception e) {
			writer.write(new StreamBlockingException());
		}finally{
			writer.close();
			if (results!=null){
				try {
					results.close();
				} catch (SQLException e) {
					logger.error("general Error", e);
				}	
			}
		}

	}


	/**
	 * Return a ResultSet of scientific names
	 */
	private ResultSet createResultSet(String scientificName) {

		ConnectionPool pool = null;
		ResultSet results = null;
		try {
			pool = ConnectionPool.getConnectionPool();

			String term = "%" + scientificName + "%";

			String query = "select id, scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from "+ FloraPlugin.tableName + " where UPPER(scientific_name) like UPPER(?)";
			results =  pool.selectPrestatement(query, term);
		}
		catch (ConnectionPoolException e) {
			logger.error("ConnectionPoolException", e);
		}finally{

		}
		return results;
	}


	@Override
	public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
		try{
			while(ids.hasNext()) {
				String id = ids.next(); 
				TaxonomyItem item = null;
				try {
					item = retrieveTaxonById(id);
					if (item!=null){
						if (writer.isAlive() && (item!=null))
							writer.write(item);
						else
							break;
					}
				} catch (IdNotValidException e) {
					logger.error("Id Not Valid", e);
				}
			}
		}catch (Exception e) {
			writer.write(new StreamBlockingException());					
		}finally{
			writer.close();
		}
	}


	@Override
	public TaxonomyItem retrieveTaxonById(String id)
			throws IdNotValidException {

		TaxonomyItem item = null;
		RSItem rs = getRSItemById(id);

		if (rs!=null){
			try {
				item = createTaxonomyItem(rs, true);
			} catch (SQLException e) {
				logger.error("Id not valid exception", e);
			}
		}
		else throw new IdNotValidException(id);
		return item;
	}


	/**
	 * get rsItem by id
	 */
	private RSItem getRSItemById(String id) {

		RSItem item = null;
		ConnectionPool pool = null;

		ResultSet results = null;

		try {
			pool = ConnectionPool.getConnectionPool();

			String query ="select id, scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from "+ FloraPlugin.tableName + " where id = ?";			

			results =  pool.selectPrestatement(query, id);	

			if(results.next()) {	
				item = new RSItem();
				item.setId(results.getString(1));
				item.setScientific_name(results.getString(2));
				item.setRank(results.getString(3));
				item.setStatus(results.getString(4));
				item.setParentId(results.getString(5));
				item.setAuthor(results.getString(6));
				item.setAcceptednameusageid(results.getString(7));
				item.setQualifier(results.getString(8));				
			}				
		}
		catch (Throwable e) {
			logger.error("Id not valid exception", e);

		}finally{
			if (results!=null){
				try {
					results.close();
				} catch (SQLException e) {
					logger.error("general Error", e);
				}	
			}
		}
		return item;
	}


}
