/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.UpdateThread;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;

class UpdateSynonymsThread
extends Thread {
    static GCUBELog logger = new GCUBELog(UpdateThread.class);
    long nextup;

    UpdateSynonymsThread(long update) {
        super("Thread");
        this.nextup = update;
        this.start();
    }

    @Override
    public void run() {
        Date date = new Date();
        logger.trace((Object)("Synonyms table in Flora DB will be updated on " + Utils.nextUpdateDate(this.nextup + date.getTime())));
        while (true) {
            try {
                while (true) {
                    UpdateSynonymsThread.sleep(this.nextup);
                    if (!UpdateSynonymsThread.synonyms()) continue;
                    this.nextup = 2764800000L;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)"General Error", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean synonyms() throws SQLException {
        ResultSet res = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            logger.trace((Object)"select a.id, a.name, a.rank, b.name, c.name, a.id_parent from flora as a join flora as b on (a.rank = 'SubSpecies' or a.rank = 'Species' or a.rank = 'Genus') and a.id_parent = b.id join flora as c on b.id_parent=c.id where a.status = 'Accepted name'");
            res = pool.selectPrestatement("select a.id, a.name, a.rank, b.name, c.name, a.id_parent from flora as a join flora as b on (a.rank = 'SubSpecies' or a.rank = 'Species' or a.rank = 'Genus') and a.id_parent = b.id join flora as c on b.id_parent=c.id where a.status = 'Accepted name'", null);
            while (res.next()) {
                String id = res.getString(1);
                String name = res.getString(2);
                String rank = res.getString(3);
                String parent = res.getString(4);
                String grandparent = res.getString(5);
                String id_parent = res.getString(6);
                String pathUrl = "";
                if (rank.equals("Genus")) {
                    pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + name.replace(" ", "%20");
                } else if (rank.equals("Species")) {
                    pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + parent + "/SPECIES/" + name.replace(" ", "%20");
                } else if (rank.equals("SubSpecies")) {
                    pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + grandparent + "/SPECIES/" + parent + "/SUBSPECIES/" + name.replace(" ", "%20");
                }
                UpdateSynonymsThread.insertSynonym(id, id_parent, pathUrl);
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"SQL Exception", (Throwable)sqlExcept);
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            e.printStackTrace();
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void insertSynonym(String id, String id_parent, String pathUrl) {
        block25: {
            try {
                String idSyn = "";
                String stmt = "";
                Map<String, String> values = null;
                if (!Utils.urlExists(pathUrl)) break block25;
                InputStream is = null;
                XMLEventReader eventReader = null;
                try {
                    is = URI.create(pathUrl.replace("\u00a0", "")).toURL().openStream();
                    XMLInputFactory ifactory = XMLInputFactory.newInstance();
                    eventReader = ifactory.createXMLEventReader(is, "utf-8");
                    while (eventReader.hasNext()) {
                        XMLEvent event = eventReader.nextEvent();
                        if (Utils.checkStartElement(event, "id")) {
                            idSyn = Utils.readCharacters(eventReader);
                            continue;
                        }
                        if (Utils.checkEndElement(event, "result")) {
                            break;
                        }
                        if (!Utils.checkEndElement(event, "record") || idSyn.equals(id)) continue;
                        ConnectionPool pool = null;
                        Connection con = null;
                        ResultSet res = null;
                        try {
                            pool = ConnectionPool.getConnectionPool();
                            con = pool.getConnection();
                            ArrayList<String> terms = new ArrayList<String>();
                            res = pool.selectPrestatement("select count(*) from flora where id = ? ", idSyn);
                            if (!res.next() || res.getInt(1) != 0) continue;
                            values = Utils.findTags(idSyn);
                            terms.add(idSyn);
                            terms.add(values.get("rank"));
                            terms.add(values.get("plain_name"));
                            terms.add(id_parent);
                            terms.add(values.get("author"));
                            terms.add(id);
                            terms.add(values.get("status"));
                            terms.add(pathUrl);
                            terms.add(values.get("qualifier"));
                            stmt = "insert into flora (id, rank, scientific_name, id_parent, citation, acceptednameusageid, status, path, qualifier) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            if (!pool.preStatement(stmt, terms)) {
                                logger.trace((Object)"error");
                            }
                            terms.clear();
                            values.clear();
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error reading " + pathUrl));
                        }
                        finally {
                            if (res != null) {
                                res.close();
                            }
                            if (pool == null || con == null) continue;
                            pool.releaseConnection(con);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
                }
                finally {
                    try {
                        if (eventReader != null) {
                            eventReader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (XMLStreamException e) {
                        logger.error((Object)"XMLStreamException", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"General Error", (Throwable)e);
            }
        }
    }
}

