/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.FloraPlugin;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);

    Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean urlExists(String pathUrl) {
        HttpURLConnection con = null;
        try {
            HttpURLConnection.setFollowRedirects(false);
            con = (HttpURLConnection)new URL(pathUrl).openConnection();
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            con.setRequestMethod("HEAD");
            boolean bl = con.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static boolean createDB() throws SQLException, IOException {
        BufferedReader br = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            logger.trace((Object)"Create tables...");
            br = new BufferedReader(new InputStreamReader(FloraPlugin.class.getResourceAsStream("/createFloraDb.sql")));
            if (br != null) {
                String line;
                while ((line = br.readLine()) != null) {
                    boolean updateQuery = pool.insertPreStatement(line);
                    if (updateQuery) continue;
                    logger.trace((Object)line);
                }
            }
        }
        catch (ConnectionPoolException e) {
            return false;
        }
        return true;
    }

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCitation() {
        StringBuilder cit = new StringBuilder();
        cit.append("Accessed through: Lista de Esp\u00e9cies da Flora do Brasil - Jardim Bot\u00e2nico do Rio de Janeiro at http://floradobrasil.jbrj.gov.br/2012/ on ");
        cit.append(Utils.createDate());
        return cit.toString();
    }

    public static String createCredits() {
        String cred = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with Lista de Esp\u00e9cies da Flora do Brasil (http://floradobrasil.jbrj.gov.br/)";
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }

    public static String getTagValue(String sTag, Element eElement) {
        Node nValue;
        NodeList textFNList;
        Element xmlNode;
        String a = "";
        NodeList nlList = eElement.getElementsByTagName(sTag);
        if (nlList != null && (xmlNode = (Element)nlList.item(0)) != null && (textFNList = xmlNode.getChildNodes()) != null && (nValue = textFNList.item(0)) != null) {
            a = nValue.getNodeValue();
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> findTags(String id) throws SQLException, ConnectException {
        String pathUrl = FloraPlugin.baseurl + "/FULLRECORD/VERSION/2012/FORMAT/xml/LANG/en/ID/" + id;
        HashMap<String, String> values = new HashMap<String, String>();
        if (Utils.urlExists(pathUrl)) {
            InputStream is = null;
            XMLEventReader eventReader = null;
            try {
                is = URI.create(pathUrl).toURL().openStream();
                XMLInputFactory ifactory = XMLInputFactory.newInstance();
                eventReader = ifactory.createXMLEventReader(is, "utf-8");
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (Utils.checkStartElement(event, "plain_name")) {
                        values.put("plain_name", Utils.readCharacters(eventReader));
                        continue;
                    }
                    if (Utils.checkStartElement(event, "author")) {
                        values.put("author", Utils.readCharacters(eventReader));
                        continue;
                    }
                    if (Utils.checkStartElement(event, "rank")) {
                        values.put("rank", Utils.readCharacters(eventReader));
                        continue;
                    }
                    if (Utils.checkStartElement(event, "status")) {
                        values.put("status", Utils.readCharacters(eventReader));
                        continue;
                    }
                    if (Utils.checkStartElement(event, "qualifier")) {
                        values.put("qualifier", Utils.readCharacters(eventReader));
                        continue;
                    }
                    if (!Utils.checkEndElement(event, "record")) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.trace((Object)("Error reading " + pathUrl));
            }
            finally {
                try {
                    if (eventReader != null) {
                        eventReader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (XMLStreamException e) {
                    logger.error((Object)"XMLStreamException", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)"IOException", (Throwable)e);
                }
            }
        }
        return values;
    }

    protected static String readCharacters(XMLEventReader eventReader) throws Exception {
        String characters = "";
        XMLEvent event = eventReader.nextEvent();
        while (eventReader.hasNext() && event.isCharacters()) {
            characters = characters + event.asCharacters().getData();
            event = eventReader.nextEvent();
        }
        return characters.trim();
    }

    protected static boolean checkStartElement(XMLEvent event, String value) {
        return event.getEventType() == 1 && event.asStartElement().getName().getLocalPart().equals(value);
    }

    protected static boolean checkEndElement(XMLEvent event, String value) {
        return event.getEventType() == 2 && event.asEndElement().getName().getLocalPart().equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ArrayList<String>> discoverPath(String pathUrl, String id_parent, String name_parent, Integer idThread, Boolean flag) throws SQLException, MalformedURLException, IOException {
        ArrayList<ArrayList<String>> listUrls = new ArrayList<ArrayList<String>>();
        if (Utils.urlExists(pathUrl)) {
            String id = "";
            String path = "";
            String rank = "";
            String name = "";
            InputStream is = null;
            XMLEventReader eventReader = null;
            try {
                is = URI.create(pathUrl).toURL().openStream();
                XMLInputFactory ifactory = XMLInputFactory.newInstance();
                eventReader = ifactory.createXMLEventReader(is, "utf-8");
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (Utils.checkStartElement(event, "id")) {
                        id = Utils.readCharacters(eventReader);
                        continue;
                    }
                    if (Utils.checkStartElement(event, "path")) {
                        path = Utils.readCharacters(eventReader);
                        continue;
                    }
                    if (Utils.checkStartElement(event, "rank")) {
                        rank = Utils.readCharacters(eventReader);
                        continue;
                    }
                    if (Utils.checkStartElement(event, "name")) {
                        name = Utils.readCharacters(eventReader);
                        continue;
                    }
                    if (Utils.checkEndElement(event, "record")) {
                        Utils.createOrUpdate(id_parent, id, name, path, rank);
                        if (flag.booleanValue()) {
                            Utils.discoverPath("http://checklist.florabrasil.net/service/TREE/VERSION/2012/FORMAT/xml/LANG/en/PATH/" + path, id, name, idThread, flag);
                            continue;
                        }
                        ArrayList<String> elem = new ArrayList<String>();
                        elem.add(path);
                        elem.add(id);
                        elem.add(name);
                        listUrls.add(elem);
                        continue;
                    }
                    if (!Utils.checkEndElement(event, "result")) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
            }
            finally {
                try {
                    if (eventReader != null) {
                        eventReader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (XMLStreamException e) {
                    logger.error((Object)"XMLStreamException", (Throwable)e);
                }
            }
        }
        return listUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createOrUpdate(String id_parent, String id, String name, String path, String rank) {
        ResultSet res = null;
        String stmt = "";
        ArrayList<String> terms = new ArrayList<String>();
        Map<String, String> values = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            res = pool.selectPrestatement("select count(*) from flora where id = ? ", id);
            if (res.next() && (values = Utils.findTags(id)).size() > 0) {
                terms.add(id);
                terms.add(rank);
                terms.add(name);
                terms.add(values.get("plain_name"));
                terms.add(id_parent);
                terms.add(values.get("author"));
                terms.add(values.get("status"));
                terms.add(path);
                terms.add(values.get("qualifier"));
                stmt = res.getInt(1) == 0 ? "insert into flora (id, rank, name, scientific_name, id_parent, citation, status, path, qualifier) values (?, ?, ?, ?, ?, ?, ?, ?, ?)" : "update flora set id = ?, rank = ?, name = ?, scientific_name = ?, id_parent = ?, citation = ?, status = ?, path = ?, qualifier = ? where id = '" + id + "'";
                if (!pool.preStatement(stmt, terms)) {
                    logger.trace((Object)"error");
                }
                terms.clear();
                values.clear();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        catch (ConnectException e) {
            logger.error((Object)"Connection timed out", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            if (pool != null && (con = pool.getConnection()) != null) {
                String sqlText;
                Statement statement = con.createStatement();
                results = statement.executeQuery(sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'");
                if (results.next()) {
                    logger.trace((Object)(tableName + " already exists"));
                    exists = true;
                } else {
                    logger.trace((Object)(tableName + " does not exists"));
                    exists = false;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        long nextUpdate = 0L;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            if (con != null) {
                Statement statement = con.createStatement();
                String query = "select date from updates where id = (select max(id) from updates)";
                logger.trace((Object)query);
                results = statement.executeQuery(query);
                Date lastUpdate = null;
                if (results.next()) {
                    lastUpdate = results.getDate(1);
                    java.util.Date date = new java.util.Date();
                    long days = date.getTime() - lastUpdate.getTime();
                    if (days < 2592000000L) {
                        long l = 2592000000L - days;
                        return l;
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return nextUpdate;
    }

    public static String nextUpdateDate(long input) {
        java.util.Date date = new java.util.Date(input);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(date);
    }
}

