/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.flora.dbconnection.RSItem;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamBlockingException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        block8: {
            this.logger.trace((Object)"getSynonimnsByIds");
            RSItem rs = null;
            try {
                rs = this.getSynbyId(id);
                if (rs == null) break block8;
                TaxonomyItem item = null;
                try {
                    item = this.createTaxonomyItem(rs, true);
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
                if (item != null && writer.isAlive()) {
                    writer.write((Object)item);
                }
            }
            catch (Exception e) {
                writer.write((StreamException)new StreamBlockingException());
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSItem getSynbyId(String id) {
        RSItem item = null;
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where acceptednameusageid = ?";
            results = pool.selectPrestatement(query, id);
            if (results != null && results.next()) {
                item = new RSItem();
                item.setId(id);
                item.setScientific_name(results.getString(1));
                item.setRank(results.getString(2));
                item.setStatus(results.getString(3));
                item.setParentId(results.getString(4));
                item.setAuthor(results.getString(5));
                item.setAcceptednameusageid(results.getString(6));
                item.setQualifier(results.getString(7));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return item;
    }

    private TaxonomyItem createTaxonomyItem(RSItem results, boolean flag) throws SQLException {
        TaxonomyItem item = null;
        try {
            String id = results.getId();
            String ScName = results.getScientific_name();
            String rank = results.getRank();
            String status = results.getStatus();
            String idParent = results.getParentId();
            String author = results.getAuthor();
            String acceptednameusageid = results.getAcceptednameusageid();
            String qualifier = results.getQualifier();
            item = new TaxonomyItem(id);
            item.setScientificName(ScName);
            item.setRank(rank);
            item.setAuthor(author);
            item.setStatus(ClassificationCapabilityImpl.setTaxonomicStatus(status, acceptednameusageid, qualifier));
            item.setCitation(Utils.createCitation());
            item.setCredits(Utils.createCredits());
            if (flag && idParent != null) {
                try {
                    item.setParent(this.retrieveTaxonById(idParent));
                }
                catch (IdNotValidException e) {
                    this.logger.error((Object)"Id Not Valid", (Throwable)e);
                }
            } else {
                item.setParent(null);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ID not valid Exception", (Throwable)e);
        }
        return item;
    }

    public static TaxonomyStatus setTaxonomicStatus(String status, String id_syn, String qualifier) {
        TaxonomyStatus t = status == null ? new TaxonomyStatus(qualifier, TaxonomyStatus.Status.UNKNOWN) : (status.equals("Accepted name") ? new TaxonomyStatus(qualifier, TaxonomyStatus.Status.ACCEPTED) : (status.equals("Synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, id_syn, qualifier) : new TaxonomyStatus(qualifier, TaxonomyStatus.Status.UNKNOWN)));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
        ArrayList<TaxonomyItem> list = null;
        ResultSet results = null;
        try {
            results = this.createResultItemChilds(id);
            if (results != null) {
                list = new ArrayList<TaxonomyItem>();
                while (results.next()) {
                    RSItem item = new RSItem();
                    item.setId(results.getString(8));
                    item.setScientific_name(results.getString(1));
                    item.setRank(results.getString(2));
                    item.setStatus(results.getString(3));
                    item.setParentId(results.getString(4));
                    item.setAuthor(results.getString(5));
                    item.setAcceptednameusageid(results.getString(6));
                    item.setQualifier(results.getString(7));
                    TaxonomyItem tax = this.createTaxonomyItem(item, false);
                    if (tax == null) continue;
                    list.add(tax);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql Error", (Throwable)e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return list;
    }

    private ResultSet createResultItemChilds(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier, id from flora where id_parent = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    public void searchByCommonName(String arg0, ObjectWriter<TaxonomyItem> arg1, Property ... arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        block14: {
            this.logger.trace((Object)("Retrive taxa by name " + scientificName));
            ResultSet results = null;
            try {
                results = this.createResultSet(scientificName);
                if (results == null) break block14;
                while (results.next()) {
                    RSItem item = new RSItem();
                    item.setId(results.getString(1));
                    item.setScientific_name(results.getString(2));
                    item.setRank(results.getString(3));
                    item.setStatus(results.getString(4));
                    item.setParentId(results.getString(5));
                    item.setAuthor(results.getString(6));
                    item.setAcceptednameusageid(results.getString(7));
                    item.setQualifier(results.getString(8));
                    TaxonomyItem tax = this.createTaxonomyItem(item, true);
                    if (writer.isAlive() && tax != null) {
                        writer.write((Object)tax);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                writer.write((StreamException)new StreamBlockingException());
            }
            finally {
                writer.close();
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet createResultSet(String scientificName) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select id, scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where UPPER(scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        block10: {
            block7: while (true) {
                try {
                    while (ids.hasNext()) {
                        String id = ids.next();
                        TaxonomyItem item = null;
                        try {
                            item = this.retrieveTaxonById(id);
                            if (item == null) continue block7;
                            if (writer.isAlive() && item != null) {
                                writer.write((Object)item);
                                continue block7;
                            }
                            break block10;
                        }
                        catch (IdNotValidException e) {
                            this.logger.error((Object)"Id Not Valid", (Throwable)e);
                        }
                    }
                    break block10;
                }
                catch (Exception e) {
                    writer.write((StreamException)new StreamBlockingException());
                    break block10;
                }
            }
            finally {
                writer.close();
            }
        }
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        TaxonomyItem item = null;
        RSItem rs = this.getRSItemById(id);
        if (rs != null) {
            try {
                item = this.createTaxonomyItem(rs, true);
            }
            catch (SQLException e) {
                this.logger.error((Object)"Id not valid exception", (Throwable)e);
            }
        } else {
            throw new IdNotValidException(id);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSItem getRSItemById(String id) {
        RSItem item = null;
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id, scientific_name, rank, status, id_parent, citation, acceptednameusageid, qualifier from flora where id = ?";
            results = pool.selectPrestatement(query, id);
            if (results.next()) {
                item = new RSItem();
                item.setId(results.getString(1));
                item.setScientific_name(results.getString(2));
                item.setRank(results.getString(3));
                item.setStatus(results.getString(4));
                item.setParentId(results.getString(5));
                item.setAuthor(results.getString(6));
                item.setAcceptednameusageid(results.getString(7));
                item.setQualifier(results.getString(8));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"Id not valid exception", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return item;
    }
}

