/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.ClassificationCapabilityImpl;
import org.gcube.data.spd.flora.UpdateThread;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.flora.dbconnection.ConnectionPool;
import org.gcube.data.spd.flora.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.flora.dbconnection.RSItem;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.Taxon;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class FloraPlugin
extends AbstractPlugin {
    public static String jdbc;
    public static String username;
    public static String password;
    public static String baseurl;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with Lista de Esp\u00e9cies da Flora do Brasil (http://floradobrasil.jbrj.gov.br/)";
    public static final String citation = "Accessed through: Lista de Esp\u00e9cies da Flora do Brasil - Jardim Bot\u00e2nico do Rio de Janeiro at http://floradobrasil.jbrj.gov.br/2012/ on ";
    public static final String dumpDb = "/createFloraDb.sql";
    public static final String tableName = "flora";
    public static final String driver = "org.postgresql.Driver";
    GCUBELog logger = new GCUBELog(FloraPlugin.class);

    public void initialize(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (ap.getEntryname().equals("rest")) {
                baseurl = ap.getEndpoint();
                continue;
            }
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            username = ap.getUsername();
            password = ap.getPassword();
        }
        if (!Utils.SQLTableExists(tableName) || !Utils.SQLTableExists("updates")) {
            System.out.println("Create tables");
            if (Utils.createDB()) {
                this.logger.trace((Object)"Completed.");
            }
        }
        long update = Utils.lastupdate();
        new UpdateThread(update);
    }

    public void update(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (ap.getEntryname().equals("rest")) {
                baseurl = ap.getEndpoint();
                continue;
            }
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            username = ap.getUsername();
            password = ap.getPassword();
        }
        super.update(res);
    }

    public String getDescription() {
        return "Brazilian Flora Plugin";
    }

    public String getRepositoryName() {
        return "BrazilianFlora";
    }

    public void shutdown() throws Exception {
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
            }
        };
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        block16: {
            ResultSet results = null;
            try {
                results = this.createRSNames(scientificName);
                if (results == null) break block16;
                while (results.next()) {
                    RSItem item = new RSItem();
                    item.setId(results.getString(1));
                    item.setScientific_name(results.getString(2));
                    item.setRank(results.getString(3));
                    item.setParentId(results.getString(4));
                    item.setAuthor(results.getString(5));
                    ResultItem rs = null;
                    try {
                        rs = this.createResultItem(item);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error retrieving information ", (Throwable)e);
                    }
                    if (writer.isAlive()) {
                        if (rs == null) continue;
                        writer.write((Object)rs);
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            finally {
                writer.close();
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
    }

    private ResultSet createRSNames(String scientificName) {
        ResultSet results = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select id, scientific_name, rank, id_parent, citation from flora where UPPER(scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        return results;
    }

    private ResultItem createResultItem(RSItem rs) {
        RSItem parentRS;
        String id = rs.getId();
        String ScName = rs.getScientific_name();
        String rank = rs.getRank();
        String idParent = rs.getParentId();
        String author = rs.getAuthor();
        ResultItem item = new ResultItem(id, ScName);
        item.setCitation(Utils.createCitation());
        item.setCredits(Utils.createCredits());
        item.setRank(rank);
        item.setAuthor(author);
        DataSet dataSet = new DataSet("floraid");
        dataSet.setName("Brazilian Flora");
        DataProvider dp = new DataProvider("floraid");
        dp.setName("Brazilian Flora");
        dataSet.setDataProvider(dp);
        item.setDataSet(dataSet);
        if (rank != null && idParent != null && (parentRS = this.findTaxonById(idParent)) != null) {
            Taxon parent = this.createTaxonByRSItem(parentRS);
            item.setParent(parent);
        }
        return item;
    }

    public Taxon createTaxonByRSItem(RSItem rs) {
        Taxon parent = null;
        RSItem parentRs = null;
        Taxon t = new Taxon(rs.getId());
        t.setRank(rs.getRank());
        t.setScientificName(rs.getScientific_name());
        t.setAuthor(rs.getAuthor());
        if (rs.getParentId() != null) {
            parentRs = this.findTaxonById(rs.getParentId());
            parent = this.createTaxonByRSItem(parentRs);
        }
        t.setParent(parent);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSItem findTaxonById(String id_record) {
        ResultSet results = null;
        RSItem item = null;
        ConnectionPool pool = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id_parent, rank, scientific_name, citation from flora where id = ?";
            results = pool.selectPrestatement(query, id_record);
            if (results.next()) {
                item = new RSItem();
                item.setId(id_record);
                item.setParentId(results.getString(1));
                item.setRank(results.getString(2));
                item.setScientific_name(results.getString(3));
                item.setAuthor(results.getString(4));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
        }
        return item;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://floradobrasil.jbrj.gov.br/2012/imgs/logo_fdb_2012.gif", "http://floradobrasil.jbrj.gov.br/", "The List of Species of Brazilian Flora is a project coordinated by the Botanical Garden of Rio de Janeiro in partnership with the CRIA. CRIA is responsible for the development and maintenance of the information system. The whole process of validation and inclusion of new data is done online by a network of over 400 taxonomists from Brazil and abroad. The online public version was completed in May 2010.");
        return info;
    }
}

