/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.FloraPlugin;
import org.gcube.data.spd.flora.NewThread;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.Taxon;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);
    final String dumpDb = "/createFloraDb.sql";
    final String driver = "org.postgresql.Driver";
    static final String tableSyn = "synonyms";
    static final String tableName = "flora";
    public ArrayList<ArrayList<String>> listUrls = new ArrayList();
    Connection conn = null;

    Utils() {
    }

    public Connection createConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            Class.forName("org.postgresql.Driver").newInstance();
            this.conn = DriverManager.getConnection(FloraPlugin.jdbc, FloraPlugin.username, FloraPlugin.password);
            return this.conn;
        }
        catch (Exception except) {
            logger.error((Object)"general Error", (Throwable)except);
            return null;
        }
    }

    public Taxon findTax(Integer id_record) {
        Taxon t = null;
        ResultSet results = null;
        Statement st = null;
        try {
            try {
                st = this.conn.createStatement();
                results = st.executeQuery("select id_parent, rank, scientific_name, citation from flora where id = " + id_record);
                if (results.next()) {
                    int id_parent = results.getInt(1);
                    t = new Taxon("" + id_record);
                    t.setRank(results.getString(2));
                    t.setScientificName(results.getString(3));
                    t.setCitation(results.getString(4));
                    if (id_parent != 0) {
                        t.setParent(this.findTax(id_parent));
                    } else {
                        t.setParent(null);
                    }
                    results.close();
                }
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    results.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
                try {
                    st.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
        }
        return t;
    }

    public TaxonomyItem findTaxomony(Integer id_record) {
        TaxonomyItem t = null;
        ResultSet results = null;
        Statement st = null;
        try {
            try {
                st = this.conn.createStatement();
                results = st.executeQuery("select id_parent, rank, scientific_name, citation from flora where id = " + id_record);
                if (results.next()) {
                    int id_parent = results.getInt(1);
                    t = new TaxonomyItem("" + id_record);
                    t.setRank(results.getString(2));
                    t.setScientificName(results.getString(3));
                    t.setCitation(results.getString(4));
                    t.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED));
                    if (id_parent != 0) {
                        t.setParent(this.findTaxomony(id_parent));
                    } else {
                        t.setParent(null);
                    }
                    results.close();
                }
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    results.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
                try {
                    st.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
        }
        return t;
    }

    public void shutdown() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
    }

    public ArrayList<ArrayList<String>> discoverPath(String pathUrl, Integer id_parent, String name_parent, Integer idThread, Boolean flag) throws SQLException, MalformedURLException, IOException {
        if (this.urlExists(pathUrl)) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new URL(pathUrl).openStream());
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("record");
                int temp = 0;
                while (temp < nList.getLength()) {
                    Node nNode = nList.item(temp);
                    if (nNode.getNodeType() == 1) {
                        Element eElement;
                        block31: {
                            eElement = (Element)nNode;
                            ResultSet res = null;
                            Statement stmt1 = null;
                            Statement stmt2 = null;
                            Connection con = null;
                            try {
                                try {
                                    Class.forName("org.postgresql.Driver").newInstance();
                                    con = DriverManager.getConnection(FloraPlugin.jdbc, FloraPlugin.username, FloraPlugin.password);
                                    stmt1 = con.createStatement();
                                    res = stmt1.executeQuery("select count(*) from flora where id = " + this.getTagValue("id", eElement));
                                    if (res.next() && res.getInt(1) == 0) {
                                        String sName = null;
                                        sName = this.getTagValue("rank", eElement).equals("Species") ? String.valueOf(name_parent) + " " + this.getTagValue("name", eElement) : (this.getTagValue("rank", eElement).equals("Variety") ? String.valueOf(name_parent) + " var. " + this.getTagValue("name", eElement) : (this.getTagValue("rank", eElement).equals("SubSpecies") ? String.valueOf(name_parent) + " subsp. " + this.getTagValue("name", eElement) : this.getTagValue("name", eElement)));
                                        String citation = null;
                                        citation = this.findInfo(Integer.parseInt(this.getTagValue("id", eElement)), new String[]{"author"}).get(0);
                                        stmt2 = con.createStatement();
                                        stmt2.execute("insert into flora (id, name, rank, scientific_name, id_parent, citation) values (" + this.getTagValue("id", eElement) + ",'" + this.getTagValue("name", eElement) + "','" + this.getTagValue("rank", eElement) + "', '" + sName + "', " + id_parent + ", '" + citation.replaceAll("'", "''") + "')");
                                    }
                                }
                                catch (SQLException e) {
                                    logger.error((Object)"SQL Exception", (Throwable)e);
                                    try {
                                        if (res != null) {
                                            res.close();
                                        }
                                        if (stmt1 != null) {
                                            stmt1.close();
                                        }
                                        if (stmt2 != null) {
                                            stmt2.close();
                                        }
                                        if (con != null) {
                                            con.close();
                                            con = null;
                                        }
                                        break block31;
                                    }
                                    catch (Exception e2) {
                                        logger.error((Object)"Exception", (Throwable)e2);
                                    }
                                    break block31;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (res != null) {
                                        res.close();
                                    }
                                    if (stmt1 != null) {
                                        stmt1.close();
                                    }
                                    if (stmt2 != null) {
                                        stmt2.close();
                                    }
                                    if (con != null) {
                                        con.close();
                                        con = null;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)"Exception", (Throwable)e);
                                }
                                throw throwable;
                            }
                            try {
                                if (res != null) {
                                    res.close();
                                }
                                if (stmt1 != null) {
                                    stmt1.close();
                                }
                                if (stmt2 != null) {
                                    stmt2.close();
                                }
                                if (con != null) {
                                    con.close();
                                    con = null;
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception", (Throwable)e);
                            }
                        }
                        if (flag.booleanValue()) {
                            this.discoverPath("http://checklist.florabrasil.net/service/TREE/VERSION/2012/FORMAT/xml/LANG/en/PATH/" + this.getTagValue("path", eElement), Integer.parseInt(this.getTagValue("id", eElement)), this.getTagValue("name", eElement), idThread, flag);
                        } else {
                            ArrayList<String> elem = new ArrayList<String>();
                            elem.add(this.getTagValue("path", eElement));
                            elem.add(this.getTagValue("id", eElement));
                            elem.add(this.getTagValue("name", eElement));
                            this.listUrls.add(elem);
                        }
                    }
                    ++temp;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
        return this.listUrls;
    }

    private boolean urlExists(String pathUrl) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(pathUrl).openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    public void syn() throws SQLException {
        Statement stmt1 = null;
        ResultSet res = null;
        try {
            try {
                this.conn = this.createConnection();
                stmt1 = this.conn.createStatement();
                res = stmt1.executeQuery("select a.id, a.name, a.rank, b.name, c.name, a.id_parent from flora as a join flora as b on (a.rank = 'SubSpecies' or a.rank = 'Species' or a.rank = 'Genus') and a.id_parent = b.id join flora as c on b.id_parent=c.id ORDER BY a.id");
                while (res.next()) {
                    int id = res.getInt(1);
                    String name = res.getString(2);
                    String rank = res.getString(3);
                    String parent = res.getString(4);
                    String grandparent = res.getString(5);
                    String id_parent = res.getString(6);
                    String pathUrl = "";
                    if (rank.equals("Genus")) {
                        pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + name;
                    } else if (rank.equals("Species")) {
                        pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + parent + "/SPECIES/" + name;
                    } else if (rank.equals("SubSpecies")) {
                        pathUrl = "http://www.checklist.florabrasil.net/service/VERSION/2012/FORMAT/xml/LANG/en/SYNONYMS/GENUS/" + grandparent + "/SPECIES/" + parent + "/SUBSPECIES/" + name;
                    }
                    if (!this.urlExists(pathUrl)) continue;
                    try {
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(new URL(pathUrl).openStream());
                        doc.getDocumentElement().normalize();
                        NodeList nList = doc.getElementsByTagName("record");
                        if (nList.getLength() <= 1) continue;
                        int temp = 1;
                        while (temp < nList.getLength()) {
                            block40: {
                                Node nNode = nList.item(temp);
                                if (nNode.getNodeType() == 1) {
                                    Element eElement = (Element)nNode;
                                    if (res.getInt(1) != Integer.parseInt(this.getTagValue("id", eElement))) {
                                        Statement stmt2 = null;
                                        ResultSet res4 = null;
                                        Statement stmt4 = null;
                                        Connection con = null;
                                        try {
                                            try {
                                                Class.forName("org.postgresql.Driver").newInstance();
                                                con = DriverManager.getConnection(FloraPlugin.jdbc, FloraPlugin.username, FloraPlugin.password);
                                                stmt4 = con.createStatement();
                                                res4 = stmt4.executeQuery("select count(*) from synonyms where id = " + this.getTagValue("id", eElement));
                                                if (res4.next() && res4.getInt(1) == 0) {
                                                    String plain_name = "";
                                                    String rank_syn = "";
                                                    ArrayList<String> info = this.findInfo(Integer.parseInt(this.getTagValue("id", eElement)), new String[]{"plain_name", "rank"});
                                                    if (info.get(0) != null) {
                                                        plain_name = info.get(0);
                                                    }
                                                    if (info.get(1) != null) {
                                                        rank_syn = info.get(1);
                                                    }
                                                    stmt2 = con.createStatement();
                                                    stmt2.execute("insert into synonyms (id, rank, scientific_name, id_parent, citation, id_syn) values (" + this.getTagValue("id", eElement) + ", '" + rank_syn + "', '" + plain_name + "', " + id_parent + ", '" + this.getTagValue("au", eElement).replaceAll("'", "''") + "', " + id + ")");
                                                }
                                            }
                                            catch (Exception e) {
                                                logger.error((Object)"General Error", (Throwable)e);
                                                if (res4 != null) {
                                                    res4.close();
                                                }
                                                if (stmt4 != null) {
                                                    stmt4.close();
                                                }
                                                if (stmt2 != null) {
                                                    stmt2.close();
                                                }
                                                if (con != null) {
                                                    con.close();
                                                    con = null;
                                                }
                                                break block40;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (res4 != null) {
                                                res4.close();
                                            }
                                            if (stmt4 != null) {
                                                stmt4.close();
                                            }
                                            if (stmt2 != null) {
                                                stmt2.close();
                                            }
                                            if (con != null) {
                                                con.close();
                                                con = null;
                                            }
                                            throw throwable;
                                        }
                                        if (res4 != null) {
                                            res4.close();
                                        }
                                        if (stmt4 != null) {
                                            stmt4.close();
                                        }
                                        if (stmt2 != null) {
                                            stmt2.close();
                                        }
                                        if (con != null) {
                                            con.close();
                                            con = null;
                                        }
                                    }
                                }
                            }
                            ++temp;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"General Error", (Throwable)e);
                    }
                }
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"SQL Exception", (Throwable)sqlExcept);
                if (res != null) {
                    res.close();
                }
                if (stmt1 != null) {
                    stmt1.close();
                }
                this.shutdown();
            }
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (stmt1 != null) {
                stmt1.close();
            }
            this.shutdown();
        }
    }

    private String getTagValue(String sTag, Element eElement) {
        Node nValue;
        NodeList textFNList;
        Element xmlNode;
        String a = "";
        NodeList nlList = eElement.getElementsByTagName(sTag);
        if (nlList != null && (xmlNode = (Element)nlList.item(0)) != null && (textFNList = xmlNode.getChildNodes()) != null && (nValue = textFNList.item(0)) != null) {
            a = nValue.getNodeValue();
        }
        return a;
    }

    public ArrayList<String> findInfo(Integer id, String[] strings) throws SQLException {
        String pathUrl = String.valueOf(FloraPlugin.baseurl) + "/FULLRECORD/VERSION/2012/FORMAT/xml/LANG/en/ID/" + id;
        ArrayList<String> c = new ArrayList<String>();
        if (this.urlExists(pathUrl)) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new URL(pathUrl).openStream());
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("record");
                if (nList.getLength() > 0) {
                    int temp = 0;
                    while (temp < nList.getLength()) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            int i = 0;
                            while (i < strings.length) {
                                c.add(this.getTagValue(strings[i], eElement));
                                ++i;
                            }
                        }
                        ++temp;
                    }
                }
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)"ParserConfigurationError", (Throwable)e);
            }
            catch (MalformedURLException e) {
                logger.error((Object)"MalformedURLException", (Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)"SAXException", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"IOException", (Throwable)e);
            }
        }
        return c;
    }

    public void upInfo() throws SQLException, MalformedURLException, IOException {
        ArrayList<ArrayList<String>> list = this.discoverPath("http://checklist.florabrasil.net/service/TREE/VERSION/2012/FORMAT/xml/LANG/en/", null, "", null, false);
        int n = list.size();
        while (n > 0) {
            new NewThread(list.remove(0), n);
            --n;
        }
    }

    public void createDB() throws SQLException, IOException {
        Statement stmt = null;
        try {
            try {
                String line;
                this.conn = this.createConnection();
                stmt = this.conn.createStatement();
                logger.trace((Object)"Create tables...");
                BufferedReader br = new BufferedReader(new InputStreamReader(FloraPlugin.class.getResourceAsStream("/createFloraDb.sql")));
                while ((line = br.readLine()) != null) {
                    int updateQuery = stmt.executeUpdate(line);
                    if (updateQuery != 0) continue;
                    logger.trace((Object)line);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
                if (stmt != null) {
                    stmt.close();
                }
                this.shutdown();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.shutdown();
        }
    }

    public boolean SQLTableExists(String tableName) {
        boolean exists;
        block16: {
            exists = false;
            ResultSet rs = null;
            Statement stmt = null;
            try {
                try {
                    this.conn = this.createConnection();
                    stmt = this.conn.createStatement();
                    String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
                    rs = stmt.executeQuery(sqlText);
                    if (rs.next()) {
                        exists = true;
                        break block16;
                    }
                    exists = false;
                }
                catch (SQLException e) {
                    logger.error((Object)"SQLException", (Throwable)e);
                    this.shutdown();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        logger.error((Object)"SQLException", (Throwable)e2);
                    }
                }
            }
            finally {
                this.shutdown();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"SQLException", (Throwable)e);
                }
            }
        }
        return exists;
    }

    public void search(String scientificName, ObjectWriter<ResultItem> writer, String table) {
        ResultSet results = null;
        Statement stmt1 = null;
        ResultItem rs = null;
        int id = 0;
        try {
            try {
                this.conn = this.createConnection();
                stmt1 = this.conn.createStatement();
                if (table.equals(tableName)) {
                    results = stmt1.executeQuery("select id, scientific_name, rank, id_parent, citation from flora where UPPER(scientific_name) like UPPER('%" + scientificName + "%')");
                } else if (table.equals(tableSyn)) {
                    results = stmt1.executeQuery("select id, scientific_name, rank, id_parent, citation from synonyms where id_syn = " + scientificName);
                }
                while (results.next()) {
                    id = results.getInt(1);
                    String ScName = results.getString(2);
                    String rank = results.getString(3);
                    String idParent = results.getString(4);
                    String citation = results.getString(5);
                    String credits = "Forzza, R.C.; Leitman, P.M.; Costa, A.F.; Carvalho Jr., A.A.; Peixoto, A.L.; Walter, B.M.T.; Bicudo, C.; Zappi, D.; Costa, D.P.; Lleras, E.; Martinelli, G.; Lima, H.C.; Prado, J.; Stehmann, J.R.; Baumgratz, J.F.A.; Pirani, J.R.; Sylvestre, L.; Maia, L.C.; Lohmann, L.G.; Queiroz, L.P.; Silveira, M.; Coelho, M.N.; Mamede, M.C.; Bastos, M.N.C.; Morim, M.P.; Barbosa, M.R.; Menezes, M.; Hopkins, M.; Secco, R.; Cavalcanti, T.B.; Souza, V.C. 2010. Introdu\u00e7\u00e3o. in Lista de Esp\u00e9cies da Flora do Brasil. Jardim Bot\u00e2nico do Rio de Janeiro.";
                    rs = new ResultItem(Integer.toString(id), ScName);
                    rs.setCredits(credits);
                    rs.setRank(rank);
                    rs.setCitation(citation);
                    DataSet dataSet = new DataSet("floraid");
                    dataSet.setName("Brazilian Flora");
                    DataProvider dp = new DataProvider("floraid");
                    dp.setName("Brazilian Flora");
                    dataSet.setDataProvider(dp);
                    rs.setDataSet(dataSet);
                    if (rank != null && idParent != null) {
                        rs.setParent(this.findTax(Integer.parseInt(idParent)));
                    }
                    writer.put((Object)rs);
                }
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    this.shutdown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
            catch (Throwable e) {
                logger.error((Object)"general Error", e);
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    this.shutdown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (stmt1 != null) {
                    stmt1.close();
                }
                this.shutdown();
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }
}

