/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.flora;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.flora.ClassificationCapabilityImpl;
import org.gcube.data.spd.flora.CreateDBThread;
import org.gcube.data.spd.flora.SynonimsCapabilityImpl;
import org.gcube.data.spd.flora.UpdateSynonymsThread;
import org.gcube.data.spd.flora.UpdateThread;
import org.gcube.data.spd.flora.Utils;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class FloraPlugin
extends AbstractPlugin {
    public static String baseurl;
    public static String username;
    public static String password;
    public static String jdbc;
    GCUBELog logger = new GCUBELog(FloraPlugin.class);

    public void initialize(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (ap.getEntryname().equals("rest")) {
                baseurl = ap.getEndpoint();
                continue;
            }
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            username = ap.getUsername();
            password = ap.getPassword();
        }
        Utils util = new Utils();
        if (!util.SQLTableExists("flora") & !util.SQLTableExists("synonyms")) {
            new CreateDBThread();
        }
        new UpdateThread();
        new UpdateSynonymsThread();
    }

    public void update(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (ap.getEntryname().equals("rest")) {
                baseurl = ap.getEndpoint();
                continue;
            }
            if (!ap.getEntryname().equals("jdbc")) continue;
            jdbc = ap.getEndpoint();
            username = ap.getUsername();
            password = ap.getPassword();
        }
    }

    public String getDescription() {
        return "Brazilian Flora Plugin";
    }

    public String getRepositoryName() {
        return "BrazilianFlora";
    }

    public void shutdown() throws Exception {
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.Synonims);
            }
        };
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public SynonimsCapability getSynonimsInterface() {
        return new SynonimsCapabilityImpl();
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.logger.trace((Object)("searchByScientificName started for " + scientificName + " in BrazilianFlora"));
        Utils util = new Utils();
        try {
            util.search(scientificName, writer, "flora");
        }
        finally {
            writer.close();
        }
    }
}

