/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis.dbconnection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.gcube.data.spd.asfis.AsfisPlugin;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    public static String dbJdbc;
    private static String dbDriver;
    private static String dbLogin;
    private static String dbPassword;
    private static ConnectionPool connectionPool;
    private Vector<Connection> freeConnections;

    static {
        connectionPool = null;
    }

    private ConnectionPool() throws ConnectionPoolException {
        this.loadParameters();
        this.freeConnections = new Vector();
        this.loadDriver();
    }

    private void loadParameters() {
        dbJdbc = AsfisPlugin.jdbc;
        dbLogin = AsfisPlugin.username;
        dbPassword = AsfisPlugin.password;
        dbDriver = "org.postgresql.Driver";
    }

    private void loadDriver() throws ConnectionPoolException {
        try {
            Class.forName(dbDriver).newInstance();
        }
        catch (Exception e) {
            throw new ConnectionPoolException();
        }
    }

    public static synchronized ConnectionPool getConnectionPool() throws ConnectionPoolException {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool();
        }
        return connectionPool;
    }

    public synchronized Connection getConnection() throws ConnectionPoolException, SQLException {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                con = this.getConnection();
            }
        } else if (this.freeConnections.size() < 100) {
            con = this.newConnection();
        }
        return con;
    }

    private Connection newConnection() throws ConnectionPoolException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(dbJdbc, dbLogin, dbPassword);
        }
        catch (SQLException e) {
            throw new ConnectionPoolException();
        }
        return con;
    }

    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.add(con);
    }

    public boolean preStatement(String query, ArrayList<String> terms, PreparedStatement stmt) {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                stmt = con.prepareStatement(query);
                int i = 0;
                while (i < terms.size()) {
                    stmt.setString(i + 1, terms.get(i));
                    ++i;
                }
                log.info(stmt.toString());
                stmt.executeUpdate();
                stmt.clearParameters();
            }
            catch (SQLException sqle) {
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
                return false;
            }
            catch (ConnectionPoolException e) {
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
                return false;
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean insertPreStatement(String query) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            stmt.executeUpdate();
            return true;
        }
        catch (SQLException sqle) {
            return false;
        }
        catch (ConnectionPoolException e) {
            return false;
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    public ResultSet selectPrestatement(String query, String term) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        try {
            try {
                pool = ConnectionPool.getConnectionPool();
                con = pool.getConnection();
                stmt = con.prepareStatement(query);
                int paramCount = 0;
                ParameterMetaData paramMetaData = stmt.getParameterMetaData();
                if (paramMetaData != null) {
                    paramCount = paramMetaData.getParameterCount();
                }
                if (term != null & paramCount > 0) {
                    int i = 0;
                    while (i < paramCount) {
                        stmt.setString(i + 1, term);
                        ++i;
                    }
                }
                result = stmt.executeQuery();
            }
            catch (SQLException e) {
                log.error("SQLException", (Throwable)e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (ConnectionPoolException e) {
                log.error("ConnectionPoolException", (Throwable)e);
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return result;
    }
}

