/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import java.util.Map;
import org.gcube.data.simulfishgrowthdata.util.GCubeUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HibernateUtil {
    private static final Logger logger = LoggerFactory.getLogger(HibernateUtil.class);
    private static HibernateUtil inst = null;
    private SessionFactory sessionFactory;
    public static final String COUNT_COLUMN_NAME = "COUNT_VALUE";
    private static String dbEndpoint = null;
    private static String scope = null;
    private boolean debugLoadFromLocalXml = false;

    public static synchronized SessionFactory getSessionFactory() {
        return HibernateUtil.getInstance().sessionFactory;
    }

    public static String getCountColumnName() {
        return "COUNT_VALUE";
    }

    public static void closeSession(Session session) {
        try {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        catch (HibernateException he) {
            logger.error(he.getMessage());
        }
    }

    public static Session openSession() throws HibernateException {
        return HibernateUtil.openSession((SessionFactory)HibernateUtil.getSessionFactory());
    }

    public static Session openSession(SessionFactory sessionFactory) throws HibernateException {
        return sessionFactory.getCurrentSession();
    }

    private static synchronized HibernateUtil getInstance() {
        if (inst == null) {
            throw new RuntimeException("Not configured yet. Please call config");
        }
        return inst;
    }

    public static synchronized void config(String dbEndpoint, String scope) {
        HibernateUtil.dbEndpoint = dbEndpoint;
        HibernateUtil.scope = scope;
        if (inst != null && HibernateUtil.inst.sessionFactory != null) {
            HibernateUtil.inst.sessionFactory.close();
            HibernateUtil.inst.sessionFactory = null;
        }
        inst = new HibernateUtil();
    }

    public static synchronized void configGently(String dbEndpoint, String scope) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("dbEndpoint [%s] scope [%s]", dbEndpoint, scope));
        }
        if (inst == null || HibernateUtil.inst.sessionFactory == null) {
            HibernateUtil.config((String)dbEndpoint, (String)scope);
        }
    }

    private HibernateUtil() {
        try {
            Configuration configuration = new Configuration();
            configuration = configuration.configure();
            configuration.configure("hibernate.cfg.xml");
            configuration.addResource("entities.hbm.xml");
            configuration.setProperty("hibernate.current_session_context_class", "thread");
            configuration.setProperty("hibernate.temp.use_jdbc_metadata_defaults", "false");
            if (this.debugLoadFromLocalXml) {
                if (logger.isTraceEnabled()) {
                    logger.trace("configure on local xml");
                }
            } else if (GCubeUtils.isPrefilledDBCredentials()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("configure on prefilled values");
                }
                HibernateUtil.fillConfiguration((Configuration)configuration, (Map)GCubeUtils.getPrefilledCredentials());
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("configure on endpoint discovery");
                }
                HibernateUtil.fillConfiguration((Configuration)configuration, (Map)GCubeUtils.getCredentials((String)dbEndpoint, (String)scope));
            }
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties());
            this.sessionFactory = configuration.buildSessionFactory((ServiceRegistry)builder.build());
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("sessionFactory %s", this.sessionFactory));
            }
        }
        catch (Exception e) {
            logger.error("Problem Connecting to the database", (Throwable)e);
            e.printStackTrace();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("after hibernate ctor sessionFactory %s", this.sessionFactory));
        }
    }

    private static void fillConfiguration(Configuration configuration, Map<String, String> confProperties) throws Exception {
        for (Map.Entry<String, String> entry : confProperties.entrySet()) {
            configuration.setProperty(entry.getKey(), entry.getValue());
        }
    }
}

