/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessPointer {
    private static final Logger logger = LoggerFactory.getLogger(AccessPointer.class);
    String mName;
    String mAdditionalCondition;

    public AccessPointer(String name) {
        this.mName = name;
    }

    public ServiceEndpoint.AccessPoint getIt() throws Exception {
        ServiceEndpoint.AccessPoint toRet = null;
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", this.mName));
            if (this.mAdditionalCondition != null && !this.mAdditionalCondition.isEmpty()) {
                query.addCondition(this.mAdditionalCondition);
            }
            query.setResult("<accesspoint><id>{$resource/ID/text()}</id>{$resource/Profile/AccessPoint}</accesspoint>");
            DiscoveryClient client = ICFactory.clientFor(AccessPointResult.class);
            List results = client.submit((Query)query);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("queried [%s] items", results.size()));
            }
            if (results != null && !results.isEmpty()) {
                toRet = ((AccessPointResult)results.get((int)0)).ap;
            }
        }
        catch (Exception e) {
            throw new Exception(String.format("Error getting access point [%s]", this.mName), e);
        }
        return toRet;
    }

    public AccessPointer addCondition(String condition) {
        this.mAdditionalCondition = condition;
        return this;
    }

    @XmlRootElement(name="accesspoint")
    static class AccessPointResult {
        @XmlElement(name="id")
        String id;
        @XmlElementRef
        ServiceEndpoint.AccessPoint ap;

        AccessPointResult() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AccessPointResult [").append("id=").append(this.id).append(", ap=").append(this.ap).append("]");
            return builder.toString();
        }
    }
}

