/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.cite.geoanalytics.environmental.data.retriever.OxygenRetriever;
import gr.cite.geoanalytics.environmental.data.retriever.model.Unit;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.Usage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SiteFullUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteUtil
extends BaseUtil {
    String additionalSimilarityConstraint = null;
    private static final String _GET_ON_OWNERID_DESIGNATION = "FROM gr.i2s.fishgrowth.model.Site s WHERE s.ownerId = :ownerid AND s.designation = :designation";
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Site s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_USAGE_ON_OWNERID = "SELECT us.id as id, us.simulcount as usage FROM siteusageview us inner join site e on (us.id=e.id) WHERE e.ownerId = :ownerid ORDER BY us.id ASC";
    private static final String _DELETE_FROM_SIMILARS = "DELETE FROM SimilarSite s WHERE s.siteId=:siteId OR similarId = :siteId";
    private static final String _DELETE_PAIR_FROM_SIMILARS = "DELETE FROM SimilarSite s WHERE (s.siteId=:siteId AND s.similarId = :similarId) OR (s.siteId=:similarId AND s.similarId = :siteId)";
    private static final String _GET_AS_GLOBAL = "Select 0 as id, cast ('ownerid' as VARCHAR) as \"ownerId\", cast ('designation' as VARCHAR) as \"designation\", cast (round(avg(periodJana)) as INTEGER) as \"periodJanA\", cast (round(avg(periodJanb)) as INTEGER) as \"periodJanB\", cast (round(avg(periodFeba)) as INTEGER) as \"periodFebA\", cast (round(avg(periodFebb)) as INTEGER) as \"periodFebB\", cast (round(avg(periodMara)) as INTEGER) as \"periodMarA\", cast (round(avg(periodMarb)) as INTEGER) as \"periodMarB\", cast (round(avg(periodapra)) as INTEGER) as \"periodAprA\", cast (round(avg(periodaprb)) as INTEGER) as \"periodAprB\", cast (round(avg(periodMaya)) as INTEGER) as \"periodMayA\", cast (round(avg(periodMayb)) as INTEGER) as \"periodMayB\", cast (round(avg(periodJuna)) as INTEGER) as \"periodJunA\", cast (round(avg(periodJunb)) as INTEGER) as \"periodJunB\", cast (round(avg(periodJula)) as INTEGER) as \"periodJulA\", cast (round(avg(periodJulb)) as INTEGER) as \"periodJulB\", cast (round(avg(periodauga)) as INTEGER) as \"periodAugA\", cast (round(avg(periodaugb)) as INTEGER) as \"periodAugB\", cast (round(avg(periodSepa)) as INTEGER) as \"periodSepA\", cast (round(avg(periodSepb)) as INTEGER) as \"periodSepB\", cast (round(avg(periodOcta)) as INTEGER) as \"periodOctA\", cast (round(avg(periodOctb)) as INTEGER) as \"periodOctB\", cast (round(avg(periodNova)) as INTEGER) as \"periodNovA\", cast (round(avg(periodNovb)) as INTEGER) as \"periodNovB\", cast (round(avg(periodDeca)) as INTEGER) as \"periodDecA\", cast (round(avg(periodDecb)) as INTEGER) as \"periodDecB\", cast (round(avg(oxygenPeriodJana)) as INTEGER) as \"oxygenPeriodJanA\", cast (round(avg(oxygenPeriodJanb)) as INTEGER) as \"oxygenPeriodJanB\", cast (round(avg(oxygenPeriodFeba)) as INTEGER) as \"oxygenPeriodFebA\", cast (round(avg(oxygenPeriodFebb)) as INTEGER) as \"oxygenPeriodFebB\", cast (round(avg(oxygenPeriodMara)) as INTEGER) as \"oxygenPeriodMarA\", cast (round(avg(oxygenPeriodMarb)) as INTEGER) as \"oxygenPeriodMarB\", cast (round(avg(oxygenPeriodapra)) as INTEGER) as \"oxygenPeriodAprA\", cast (round(avg(oxygenPeriodaprb)) as INTEGER) as \"oxygenPeriodAprB\", cast (round(avg(oxygenPeriodMaya)) as INTEGER) as \"oxygenPeriodMayA\", cast (round(avg(oxygenPeriodMayb)) as INTEGER) as \"oxygenPeriodMayB\", cast (round(avg(oxygenPeriodJuna)) as INTEGER) as \"oxygenPeriodJunA\", cast (round(avg(oxygenPeriodJunb)) as INTEGER) as \"oxygenPeriodJunB\", cast (round(avg(oxygenPeriodJula)) as INTEGER) as \"oxygenPeriodJulA\", cast (round(avg(oxygenPeriodJulb)) as INTEGER) as \"oxygenPeriodJulB\", cast (round(avg(oxygenPeriodauga)) as INTEGER) as \"oxygenPeriodAugA\", cast (round(avg(oxygenPeriodaugb)) as INTEGER) as \"oxygenPeriodAugB\", cast (round(avg(oxygenPeriodSepa)) as INTEGER) as \"oxygenPeriodSepA\", cast (round(avg(oxygenPeriodSepb)) as INTEGER) as \"oxygenPeriodSepB\", cast (round(avg(oxygenPeriodOcta)) as INTEGER) as \"oxygenPeriodOctA\", cast (round(avg(oxygenPeriodOctb)) as INTEGER) as \"oxygenPeriodOctB\", cast (round(avg(oxygenPeriodNova)) as INTEGER) as \"oxygenPeriodNovA\", cast (round(avg(oxygenPeriodNovb)) as INTEGER) as \"oxygenPeriodNovB\", cast (round(avg(oxygenPeriodDeca)) as INTEGER) as \"oxygenPeriodDecA\", cast (round(avg(oxygenPeriodDecb)) as INTEGER) as \"oxygenPeriodDecB\", 1 as \"oxygenRatingId\", 1 as \"currentRatingId\", 1 as \"regionId\", cast ('' as VARCHAR) as \"latitude\", cast ('' as VARCHAR) as \"longitude\", cast (round(avg(periodyear)) as INTEGER) as \"periodYear\", cast (round(avg(oxygenPeriodyear)) as INTEGER) as \"oxygenPeriodYear\"  FROM Site where id in (:siteids)";
    private static final Logger logger = LoggerFactory.getLogger(SiteUtil.class);

    public SiteUtil setAdditionalSimilarityConstraint(String additionalSimilarityConstraint) {
        this.additionalSimilarityConstraint = additionalSimilarityConstraint;
        return this;
    }

    public Site add(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.add(session, site);
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add site [%s]", site), (Throwable)e);
            throw new Exception(String.format("Could not add site [%s]", site), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public void loadOxygen(Site site) {
        int[] oxygenBiMonthly;
        try {
            oxygenBiMonthly = ArrayUtils.toPrimitive((Integer[])new OxygenRetriever().getByLatLongAsArray(Double.valueOf(site.getLatitude()).doubleValue(), Double.valueOf(site.getLongitude()).doubleValue(), Unit.CELCIUS));
            if (oxygenBiMonthly == null || oxygenBiMonthly.length < 25) {
                throw new Exception("No proper oxygen values for (" + site.getLatitude() + ", " + site.getLongitude() + ")");
            }
        }
        catch (Exception e) {
            logger.warn("Problem retrieving oxygen. I will fill with defaults", (Throwable)e);
            oxygenBiMonthly = new int[24];
            for (int i = 0; i < 24; ++i) {
                oxygenBiMonthly[i] = 0;
            }
        }
        int i = 0;
        site.setOxygenPeriodJanA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodJanB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodFebA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodFebB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodMarA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodMarB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodAprA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodAprB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodMayA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodMayB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodJunA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodJunB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodJulA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodJulB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodAugA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodAugB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodSepA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodSepB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodOctA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodOctB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodNovA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodNovB(oxygenBiMonthly[i++]);
        site.setOxygenPeriodDecA(oxygenBiMonthly[i++]);
        site.setOxygenPeriodDecB(oxygenBiMonthly[i++]);
        int sum = 0;
        for (i = 0; i < 12; ++i) {
            sum += oxygenBiMonthly[i];
        }
        site.setOxygenPeriodYear(sum / 12);
    }

    public Site add(Session session, Site site) throws Exception {
        this.loadOxygen(site);
        session.save((Object)site);
        session.flush();
        return site;
    }

    public Site update(Session session, Site site) throws Exception {
        return this.update(session, site, new HashSet<Long>());
    }

    public Site update(Session session, Site site, Set<Long> similarsAlreadyUpdated) throws Exception {
        this.loadOxygen(site);
        session.update((Object)site);
        return site;
    }

    public Site update(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.update(session, site, new HashSet<Long>());
            session.flush();
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update site [%s]", site), (Throwable)e);
            throw new Exception(String.format("Could not update site [%s]", site), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            if (this.delete(session, id)) {
                session.flush();
            }
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete site [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not delete site [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Site getSite(Session session, Long id) throws Exception {
        Site site = (Site)session.get(Site.class, (Serializable)id);
        return site;
    }

    public Site getSite(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Site site = this.getSite(session, id);
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve site [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve site [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public List<Site> getSites(String ownerId) throws Exception {
        List<Site> list;
        Session session = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("start getSites", new Object[0]));
            }
            session = HibernateUtil.openSession();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("session [%s]", session));
            }
            session.beginTransaction();
            List<Site> list2 = this.getSites(session, ownerId);
            session.getTransaction().commit();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("return SiteFulls %s", list2));
            }
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve sites for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve sites for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public List<Site> getSites(Session session, String ownerId) throws Exception {
        Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
        List list = q.list();
        return list;
    }

    public List<Usage> getUsage(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("start getUsage", new Object[0]));
            }
            session = HibernateUtil.openSession();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("session [%s]", session));
            }
            session.beginTransaction();
            NativeQuery q = session.createSQLQuery(_GET_USAGE_ON_OWNERID).addEntity(Usage.class).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("return site usage %s", list2));
            }
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not get site usage for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not get site usage for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public Set<Long> findSitesSimilarToMeIncludingMe(Session session, Site me, Integer acceptableCount, Integer upToGrade) {
        Set<Long> toRet = this.findSitesSimilarToMe(session, me, acceptableCount, upToGrade);
        toRet.add(me.getId());
        return toRet;
    }

    public Set<Long> findSitesSimilarToMe(Session session, Site me, Integer acceptableCount, Integer upToGrade) {
        Set<Long> toRet = null;
        Integer currentGrade = 1;
        Integer curCount = toRet == null ? 0 : toRet.size();
        if (curCount < acceptableCount && currentGrade <= upToGrade) {
            toRet = this.findSitesSimilarToMeGradeA(session, me);
            curCount = toRet == null ? 0 : toRet.size();
            Integer n = currentGrade;
            Integer n2 = currentGrade = Integer.valueOf(currentGrade + 1);
            if (curCount < acceptableCount && currentGrade <= upToGrade) {
                toRet = this.findSitesSimilarToMeGradeB(session, me);
                curCount = toRet == null ? 0 : toRet.size();
                n = currentGrade;
                n2 = currentGrade = Integer.valueOf(currentGrade + 1);
                if (curCount < acceptableCount && currentGrade <= upToGrade) {
                    toRet = this.findSitesSimilarToMeGradeC(session, me);
                    curCount = toRet == null ? 0 : toRet.size();
                    n = currentGrade;
                    n2 = currentGrade = Integer.valueOf(currentGrade + 1);
                    if (curCount < acceptableCount && currentGrade <= upToGrade) {
                        toRet = this.findSitesSimilarToMeGradeD(session, me);
                        curCount = toRet == null ? 0 : toRet.size();
                        n = currentGrade;
                        n2 = currentGrade = Integer.valueOf(currentGrade + 1);
                        if (curCount < acceptableCount && currentGrade <= upToGrade) {
                            toRet = this.findSitesSimilarToMeGradeE(session, me);
                        }
                    }
                }
            }
        }
        return toRet == null ? new HashSet() : toRet;
    }

    protected Set<Long> findSitesSimilarToMeGradeA(Session session, Site me) {
        session.flush();
        int dtemp = 1;
        int dAnnualTemp = 1;
        int doxygen = 20;
        TreeSet<Long> toRet = new TreeSet<Long>(new SiteFullUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).getSiteFullSimilar(session, me, dtemp, dAnnualTemp, doxygen));
        return toRet;
    }

    protected Set<Long> findSitesSimilarToMeGradeB(Session session, Site me) {
        session.flush();
        int dtemp = 1;
        int dAnnualTemp = 1;
        int doxygen = 100000;
        TreeSet<Long> toRet = new TreeSet<Long>(new SiteFullUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).getSiteFullSimilar(session, me, dtemp, dAnnualTemp, doxygen));
        return toRet;
    }

    protected Set<Long> findSitesSimilarToMeGradeC(Session session, Site me) {
        session.flush();
        int dtemp = 2;
        int dAnnualTemp = 1;
        int doxygen = 100000;
        TreeSet<Long> toRet = new TreeSet<Long>(new SiteFullUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).getSiteFullSimilar(session, me, dtemp, dAnnualTemp, doxygen));
        return toRet;
    }

    protected Set<Long> findSitesSimilarToMeGradeD(Session session, Site me) {
        session.flush();
        int dtemp = 100000;
        int dAnnualTemp = 2;
        int doxygen = 100000;
        TreeSet<Long> toRet = new TreeSet<Long>(new SiteFullUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).getSiteFullSimilar(session, me, dtemp, dAnnualTemp, doxygen));
        return toRet;
    }

    protected Set<Long> findSitesSimilarToMeGradeE(Session session, Site me) {
        session.flush();
        int dtemp = 100000;
        int dAnnualTemp = 100000;
        int doxygen = 100000;
        TreeSet<Long> toRet = new TreeSet<Long>(new SiteFullUtil().setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).getSiteFullSimilar(session, me, dtemp, dAnnualTemp, doxygen));
        return toRet;
    }

    public Site getSiteAsGlobal(Session session, Set<Long> ids) {
        Query q = session.createSQLQuery(_GET_AS_GLOBAL).setParameterList("siteids", ids).setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(Site.class));
        List list = q.list();
        return list.isEmpty() ? null : (Site)list.get(0);
    }

    public boolean delete(Session session, Long id) {
        try {
            return this.delete(session, (Site)session.get(Site.class, (Serializable)id));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Site with id [%s]", id), e);
        }
    }

    public boolean delete(Session session, Site site) {
        try {
            if (site == null) {
                return false;
            }
            session.delete((Object)site);
            List<Modeler> models = new ModelerUtil().getModelersForSite(session, site.getId());
            for (Modeler modeler : models) {
                new ModelerUtil().delete(session, modeler);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Site  [%s]", site), e);
        }
    }
}

