/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import com.google.gson.Gson;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.gcube.data.simulfishgrowthdata.util.SocialNetworkingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageExecutor
extends SocialNetworkingExecutor {
    static final Logger logger = LoggerFactory.getLogger(SendMessageExecutor.class);
    Message mMessage = new Message();

    public SendMessageExecutor(String endpoint) {
        super(endpoint);
    }

    public SendMessageExecutor setSubject(String subject) {
        this.mMessage.subject = subject;
        return this;
    }

    public SendMessageExecutor setBody(String body) {
        this.mMessage.body = body;
        return this;
    }

    public SendMessageExecutor addRecipient(String recipient) {
        this.mMessage.recipients.add(new Recipient(recipient));
        return this;
    }

    @Override
    protected HttpUriRequest createRequest(URI uri) {
        HttpPost request = new HttpPost(uri);
        return request;
    }

    @Override
    protected String makeUri() {
        return this.mEndpoint + "/2/messages/write-message";
    }

    @Override
    protected void prepareRequest(HttpUriRequest request) {
        String messageJson = new Gson().toJson((Object)this.mMessage);
        if (logger.isTraceEnabled()) {
            logger.trace("posting ~~" + messageJson + "~~");
        }
        StringEntity entity = new StringEntity(messageJson, ContentType.APPLICATION_JSON);
        ((HttpPost)request).setEntity((HttpEntity)entity);
    }

    @Override
    protected SocialNetworkingExecutor.Response processOutput(String output) throws Exception {
        SocialNetworkingExecutor.Response response = super.processOutput(output);
        if (!response.isSuccess()) {
            throw new Exception(response.message);
        }
        return response;
    }

    static class Recipient {
        String id;

        public Recipient(String id) {
            this.id = id;
        }
    }

    static class Message {
        public String body;
        public String subject;
        public List<Recipient> recipients = new ArrayList<Recipient>();

        Message() {
        }
    }
}

