/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.model;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import gr.cite.geoanalytics.environmental.data.retriever.OxygenRetriever;
import gr.cite.geoanalytics.environmental.data.retriever.TemperatureRetriever;
import gr.cite.geoanalytics.environmental.data.retriever.model.Unit;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Sfr;
import gr.i2s.fishgrowth.model.Site;
import gr.i2s.fishgrowth.model.TableEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SiteUtil;
import org.gcube.data.simulfishgrowthdata.util.DatabaseUtil;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalModelWrapper {
    private static final Logger logger = LoggerFactory.getLogger(GlobalModelWrapper.class);
    final Session session;
    public Collection<Fcr> fcrs;
    public Collection<Sfr> sfrs;
    public Collection<Mortality> mortalities;
    public Integer[] temperatureBiMonthly;
    public Integer[] oxygenBiMonthly;
    String latitude;
    String longitude;
    Long speciesId;
    Set<Long> similarSites;
    IEnvValuesProvider temperatureProvider;
    IEnvValuesProvider oxygenProvider;
    String uniqueId = null;
    private Integer acceptableSiteCount;
    private Integer upToGrade;

    private GlobalModelWrapper(Session session) {
        this.session = session;
        this.acceptableSiteCount = 1;
        this.upToGrade = 1;
        this.temperatureBiMonthly = null;
        this.oxygenBiMonthly = null;
        this.similarSites = null;
        this.temperatureProvider = new IEnvValuesProvider(){

            @Override
            public Integer[] getValues(String latitude, String longitude) throws Exception {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("asking service for oxygen table, based on lat/long", new Object[0]));
                }
                try {
                    Integer[] toRet = new TemperatureRetriever().getByLatLongAsArray(Double.valueOf(latitude).doubleValue(), Double.valueOf(longitude).doubleValue(), Unit.CELCIUS);
                    return toRet;
                }
                catch (Exception e) {
                    throw new UserFriendlyException("Could not retrieve temperature values.", e);
                }
            }
        };
        this.oxygenProvider = new IEnvValuesProvider(){

            @Override
            public Integer[] getValues(String latitude, String longitude) throws Exception {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("asking service for oxygen table, based on lat/long", new Object[0]));
                }
                try {
                    Integer[] toRet = new OxygenRetriever().getByLatLongAsArray(Double.valueOf(latitude).doubleValue(), Double.valueOf(longitude).doubleValue(), Unit.CELCIUS);
                    return toRet;
                }
                catch (Exception e) {
                    throw new UserFriendlyException("Could not retrieve oxygen values.", e);
                }
            }
        };
    }

    public GlobalModelWrapper(Session session, String latitude, String longitude, Long speciesId) throws Exception {
        this(session);
        Site site = this.discoverVirtualSite(latitude, longitude);
        this.fillData(site);
        this.speciesId = speciesId;
    }

    public GlobalModelWrapper(Session session, String latitude, String longitude, Long speciesId, int acceptableSiteCount, int upToGrade) throws Exception {
        this(session);
        this.acceptableSiteCount = acceptableSiteCount;
        this.upToGrade = upToGrade;
        Site site = this.discoverVirtualSite(latitude, longitude);
        this.fillData(site);
        this.speciesId = speciesId;
    }

    private Site discoverVirtualSite(String latitude, String longitude) throws Exception {
        Integer[] temps = this.temperatureProvider.getValues(latitude, longitude);
        Integer[] oxy = this.oxygenProvider.getValues(latitude, longitude);
        Site toRet = this.makeSite(latitude, longitude, temps, oxy);
        Set<Long> similars = new SiteUtil().findSitesSimilarToMe(this.session, toRet, this.acceptableSiteCount, this.upToGrade);
        toRet.setDesignation(DatabaseUtil.implodeGlobalName(similars));
        return toRet;
    }

    public GlobalModelWrapper(Session session, Site site, Long speciesId) throws Exception {
        this(session);
        this.fillData(site);
        this.speciesId = speciesId;
    }

    public GlobalModelWrapper(Session session, Modeler modeler) throws Exception {
        this(session);
        Long siteId = modeler.getSiteId();
        Long globalSite = new SimilarSiteUtil().getGlobal(session, siteId);
        Site global = new SiteUtil().getSite(session, globalSite);
        this.fillData(global);
        this.fillData(modeler);
    }

    GlobalModelWrapper fillData(Site site) throws Exception {
        this.latitude = site.getLatitude();
        this.longitude = site.getLongitude();
        this.temperatureBiMonthly = new Integer[24];
        int i = 0;
        this.temperatureBiMonthly[i++] = site.getPeriodJanA();
        this.temperatureBiMonthly[i++] = site.getPeriodJanB();
        this.temperatureBiMonthly[i++] = site.getPeriodFebA();
        this.temperatureBiMonthly[i++] = site.getPeriodFebB();
        this.temperatureBiMonthly[i++] = site.getPeriodMarA();
        this.temperatureBiMonthly[i++] = site.getPeriodMarB();
        this.temperatureBiMonthly[i++] = site.getPeriodAprA();
        this.temperatureBiMonthly[i++] = site.getPeriodAprB();
        this.temperatureBiMonthly[i++] = site.getPeriodMayA();
        this.temperatureBiMonthly[i++] = site.getPeriodMayB();
        this.temperatureBiMonthly[i++] = site.getPeriodJunA();
        this.temperatureBiMonthly[i++] = site.getPeriodJunB();
        this.temperatureBiMonthly[i++] = site.getPeriodJulA();
        this.temperatureBiMonthly[i++] = site.getPeriodJulB();
        this.temperatureBiMonthly[i++] = site.getPeriodAugA();
        this.temperatureBiMonthly[i++] = site.getPeriodAugB();
        this.temperatureBiMonthly[i++] = site.getPeriodSepA();
        this.temperatureBiMonthly[i++] = site.getPeriodSepB();
        this.temperatureBiMonthly[i++] = site.getPeriodOctA();
        this.temperatureBiMonthly[i++] = site.getPeriodOctB();
        this.temperatureBiMonthly[i++] = site.getPeriodNovA();
        this.temperatureBiMonthly[i++] = site.getPeriodNovB();
        this.temperatureBiMonthly[i++] = site.getPeriodDecA();
        this.temperatureBiMonthly[i++] = site.getPeriodDecB();
        this.oxygenBiMonthly = new Integer[24];
        i = 0;
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJanA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJanB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodFebA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodFebB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodMarA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodMarB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodAprA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodAprB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodMayA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodMayB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJunA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJunB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJulA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodJulB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodAugA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodAugB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodSepA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodSepB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodOctA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodOctB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodNovA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodNovB();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodDecA();
        this.oxygenBiMonthly[i++] = site.getOxygenPeriodDecB();
        if (site.getDesignation() != null && !site.getDesignation().isEmpty()) {
            this.similarSites = DatabaseUtil.explodeGlobalName(site.getDesignation());
            this.uniqueId = site.getDesignation();
        }
        if (this.similarSites == null || this.similarSites.isEmpty()) {
            throw new Exception("No similar sites! Nothing to work on");
        }
        return this;
    }

    public GlobalModelWrapper setTemperatureProvider(IEnvValuesProvider temperatureProvider) {
        this.temperatureProvider = temperatureProvider;
        return this;
    }

    public GlobalModelWrapper setOxygenProvider(IEnvValuesProvider oxygenProvider) {
        this.oxygenProvider = oxygenProvider;
        return this;
    }

    GlobalModelWrapper fillData(Modeler modeler) {
        this.speciesId = modeler.getSpeciesId();
        return this;
    }

    public String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = DatabaseUtil.implodeGlobalName(this.similarSites);
        }
        return this.uniqueId;
    }

    public GlobalModelWrapper create() throws Exception {
        if (this.canContinue()) {
            long start = System.currentTimeMillis();
            this.constructGlobalModel(this.session, this.similarSites);
            long end = System.currentTimeMillis();
            if (logger.isTraceEnabled()) {
                logger.trace("global model constructGlobalModel " + (end - start));
            }
        }
        return this;
    }

    public Map<Integer, RangeMap<Double, Double>> fillKPITable(Collection<? extends TableEntity> list) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("fcr list from db [%s]", list));
        }
        HashMap<Integer, RangeMap<Double, Double>> table = new HashMap<Integer, RangeMap<Double, Double>>();
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (TableEntity tableEntity : list) {
            if (tableEntity.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    table.put(curTemp, (RangeMap<Double, Double>)tempColumn);
                }
                curTemp = tableEntity.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = tableEntity.getFromWeight();
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)tableEntity.getValue());
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            table.put(curTemp, (RangeMap<Double, Double>)tempColumn);
        }
        return table;
    }

    private void constructGlobalModel(Session session, Set<Long> similarSites) throws Exception {
        TreeSet<Long> similarModels;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("retrieving global model KPIs", new Object[0]));
        }
        if ((similarModels = new TreeSet<Long>(new ModelerUtil().getModelerIdsForSites(session, this.speciesId, new ArrayList<Long>(similarSites)))) == null || similarModels.isEmpty()) {
            throw new Exception("No similar models found! Nothing to do. SimilarSites are " + similarSites);
        }
        ArrayList<Long> modelIdsList = new ArrayList<Long>(similarModels);
        long start = System.currentTimeMillis();
        Map<Integer, Collection<Double>> commonWeights = new ModelerUtil().getCommonWeightLimits(session, modelIdsList);
        long end = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace("global model commonWeights " + (end - start));
        }
        start = System.currentTimeMillis();
        this.fcrs = new ModelerUtil().getCommonKPIValues(session, 1, commonWeights.get(1), modelIdsList);
        end = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace("global model fcrs " + (end - start));
        }
        start = System.currentTimeMillis();
        this.sfrs = new ModelerUtil().getCommonKPIValues(session, 2, commonWeights.get(2), modelIdsList);
        end = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace("global model sfrs " + (end - start));
        }
        start = System.currentTimeMillis();
        this.mortalities = new ModelerUtil().getCommonKPIValues(session, 4, commonWeights.get(4), modelIdsList);
        end = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace("global model mortalities " + (end - start));
        }
    }

    private boolean canContinue() {
        return this.similarSites.size() >= 1;
    }

    private Site makeSite(String latitude, String longitude, Integer[] temp, Integer[] oxy) {
        Site site = new Site();
        site.setLatitude(latitude);
        site.setLongitude(longitude);
        int i = 0;
        site.setPeriodJanA(temp[i++].intValue());
        site.setPeriodJanB(temp[i++].intValue());
        site.setPeriodFebA(temp[i++].intValue());
        site.setPeriodFebB(temp[i++].intValue());
        site.setPeriodMarA(temp[i++].intValue());
        site.setPeriodMarB(temp[i++].intValue());
        site.setPeriodAprA(temp[i++].intValue());
        site.setPeriodAprB(temp[i++].intValue());
        site.setPeriodMayA(temp[i++].intValue());
        site.setPeriodMayB(temp[i++].intValue());
        site.setPeriodJunA(temp[i++].intValue());
        site.setPeriodJunB(temp[i++].intValue());
        site.setPeriodJulA(temp[i++].intValue());
        site.setPeriodJulB(temp[i++].intValue());
        site.setPeriodAugA(temp[i++].intValue());
        site.setPeriodAugB(temp[i++].intValue());
        site.setPeriodSepA(temp[i++].intValue());
        site.setPeriodSepB(temp[i++].intValue());
        site.setPeriodOctA(temp[i++].intValue());
        site.setPeriodOctB(temp[i++].intValue());
        site.setPeriodNovA(temp[i++].intValue());
        site.setPeriodNovB(temp[i++].intValue());
        site.setPeriodDecA(temp[i++].intValue());
        site.setPeriodDecB(temp[i++].intValue());
        int sum = 0;
        for (i = 0; i < temp.length; ++i) {
            sum += temp[i].intValue();
        }
        site.setPeriodYear(sum / temp.length);
        i = 0;
        site.setOxygenPeriodJanA(oxy[i++].intValue());
        site.setOxygenPeriodJanB(oxy[i++].intValue());
        site.setOxygenPeriodFebA(oxy[i++].intValue());
        site.setOxygenPeriodFebB(oxy[i++].intValue());
        site.setOxygenPeriodMarA(oxy[i++].intValue());
        site.setOxygenPeriodMarB(oxy[i++].intValue());
        site.setOxygenPeriodAprA(oxy[i++].intValue());
        site.setOxygenPeriodAprB(oxy[i++].intValue());
        site.setOxygenPeriodMayA(oxy[i++].intValue());
        site.setOxygenPeriodMayB(oxy[i++].intValue());
        site.setOxygenPeriodJunA(oxy[i++].intValue());
        site.setOxygenPeriodJunB(oxy[i++].intValue());
        site.setOxygenPeriodJulA(oxy[i++].intValue());
        site.setOxygenPeriodJulB(oxy[i++].intValue());
        site.setOxygenPeriodAugA(oxy[i++].intValue());
        site.setOxygenPeriodAugB(oxy[i++].intValue());
        site.setOxygenPeriodSepA(oxy[i++].intValue());
        site.setOxygenPeriodSepB(oxy[i++].intValue());
        site.setOxygenPeriodOctA(oxy[i++].intValue());
        site.setOxygenPeriodOctB(oxy[i++].intValue());
        site.setOxygenPeriodNovA(oxy[i++].intValue());
        site.setOxygenPeriodNovB(oxy[i++].intValue());
        site.setOxygenPeriodDecA(oxy[i++].intValue());
        site.setOxygenPeriodDecB(oxy[i++].intValue());
        sum = 0;
        for (i = 0; i < oxy.length; ++i) {
            sum += oxy[i].intValue();
        }
        site.setOxygenPeriodYear(sum / oxy.length);
        return site;
    }

    public static interface IEnvValuesProvider {
        public Integer[] getValues(String var1, String var2) throws Exception;
    }
}

