/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.model;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.datapublishing.sdmx.model.TableIdentificators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TableAssociationResource {
    private GenericResource tableAssociation;
    private Map<String, TableIdentificators> associationsTable;
    private Logger logger = LoggerFactory.getLogger(TableAssociationResource.class);
    private boolean associationsModified;
    private final String RECORD_ELEMENT = "record";
    private final String DATAFLOW_ELEMENT = "dataflow";
    private final String TABLE_ELEMENT = "table";
    private final String TABLULAR_RESOURCE_ELEMENT = "tablularresource";
    private final String ASSOCIATIONS_ELEMENT = "associations";

    public TableAssociationResource() {
        this.tableAssociation = (GenericResource)Resources.unmarshal(GenericResource.class, (InputStream)this.getClass().getResourceAsStream("/sdmxresourcemodel.xml"));
        this.associationsTable = new HashMap<String, TableIdentificators>();
        this.associationsModified = false;
    }

    public TableAssociationResource(Map<String, TableIdentificators> associationsTable) {
        this.tableAssociation = (GenericResource)Resources.unmarshal(GenericResource.class, (InputStream)this.getClass().getResourceAsStream("/sdmxresourcemodel.xml"));
        this.associationsTable = associationsTable;
        this.associationsModified = true;
    }

    public TableAssociationResource(GenericResource tableAssociation) {
        this.tableAssociation = tableAssociation;
        this.associationsTable = this.getAssociatons(tableAssociation.profile().body());
        this.associationsModified = false;
    }

    public GenericResource getGenericResurce() {
        if (this.associationsModified) {
            this.updateResource(this.associationsTable);
        }
        return this.tableAssociation;
    }

    public void addAssociation(String flowId, String tabularResourceId, String tableId) {
        this.associationsTable.put(flowId, new TableIdentificators(tabularResourceId, tableId));
        this.associationsModified = true;
    }

    public void removeAssociation(String flowId) {
        this.associationsTable.remove(flowId);
        this.associationsModified = true;
    }

    public Map<String, TableIdentificators> getAssociationsTable() {
        return this.associationsTable;
    }

    private void updateResource(Map<String, TableIdentificators> associations) {
        this.logger.debug("Updating generic element");
        this.logger.debug("Original body " + this.tableAssociation.profile().bodyAsString());
        try {
            Element bodyElement = this.tableAssociation.profile().newBody();
            Document document = bodyElement.getOwnerDocument();
            Element associationsElement = document.createElement("associations");
            bodyElement.appendChild(associationsElement);
            Set<String> dataFlowSet = associations.keySet();
            for (String dataFlow : dataFlowSet) {
                this.logger.debug("Generating new record");
                Element recordElement = document.createElement("record");
                associationsElement.appendChild(recordElement);
                TableIdentificators tableIdentificators = associations.get(dataFlow);
                this.logger.debug("Adding data flow " + dataFlow + " table " + tableIdentificators);
                Element dataFlowElement = document.createElement("dataflow");
                Text dataFlowTextNode = document.createTextNode(dataFlow);
                dataFlowElement.appendChild(dataFlowTextNode);
                recordElement.appendChild(dataFlowElement);
                Element tableIDElement = document.createElement("table");
                Text tableIDTextNode = document.createTextNode(tableIdentificators.getTableIDString());
                tableIDElement.appendChild(tableIDTextNode);
                recordElement.appendChild(tableIDElement);
                Element tablularResourceIDElement = document.createElement("tablularresource");
                Text tablularResourceIDTextNode = document.createTextNode(tableIdentificators.getTabularResourceIDString());
                tablularResourceIDElement.appendChild(tablularResourceIDTextNode);
                recordElement.appendChild(tablularResourceIDElement);
                this.logger.debug("Record generated, new body " + this.tableAssociation.profile().bodyAsString());
            }
            this.associationsModified = false;
        }
        catch (Exception e) {
            this.logger.error("Unable to update Generic Resource");
        }
    }

    private HashMap<String, TableIdentificators> getAssociatons(Element body) {
        this.logger.debug("Parsing result " + body.getLocalName());
        NodeList nodes = body.getElementsByTagName("record");
        HashMap<String, TableIdentificators> response = new HashMap<String, TableIdentificators>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element recordElement = (Element)nodes.item(i);
            this.logger.debug("Parsing record element " + (i + 1));
            NodeList dataFlowElements = recordElement.getElementsByTagName("dataflow");
            NodeList tableElements = recordElement.getElementsByTagName("table");
            NodeList tabularResourceElements = recordElement.getElementsByTagName("tablularresource");
            if (dataFlowElements.getLength() == 0 || tableElements.getLength() == 0 || tabularResourceElements.getLength() == 0) {
                this.logger.warn("Invalid element");
                continue;
            }
            Node flowNode = dataFlowElements.item(0);
            String flowId = flowNode.getFirstChild().getNodeValue();
            this.logger.debug("Flow ID " + flowId);
            Node tableNode = tableElements.item(0);
            String tableId = tableNode.getFirstChild().getNodeValue();
            this.logger.debug("Table ID " + tableId);
            Node tablularResourceNode = tabularResourceElements.item(0);
            String tablularResourceId = tablularResourceNode.getFirstChild().getNodeValue();
            this.logger.debug("Tablular Resource ID " + tablularResourceId);
            response.put(flowId, new TableIdentificators(tablularResourceId, tableId));
        }
        return response;
    }
}

