/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx;

import java.util.Map;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.datapublishing.sdmx.is.ISDataWriter;
import org.gcube.datapublishing.sdmx.is.ISTableIDDataReader;
import org.gcube.datapublishing.sdmx.model.TableAssociationResource;
import org.gcube.datapublishing.sdmx.model.TableIdentificators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInformationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataInformationProvider.class);
    private static DataInformationProvider instance;

    private DataInformationProvider() {
    }

    public static DataInformationProvider getInstance() {
        if (instance == null) {
            instance = new DataInformationProvider();
        }
        return instance;
    }

    public TableIdentificators getTableId(String dataFlowKey) {
        logger.debug("Looking for table id of data flow " + dataFlowKey);
        TableAssociationResource tableAssociations = this.getTableAssociationResource();
        TableIdentificators tableId = null;
        if (tableAssociations == null) {
            logger.error("Information system not initialized: data not present");
        } else {
            Map<String, TableIdentificators> associations = tableAssociations.getAssociationsTable();
            tableId = associations.get(dataFlowKey);
        }
        logger.debug("Table id " + tableId);
        return tableId;
    }

    private TableAssociationResource getTableAssociationResource() {
        ISTableIDDataReader reader = new ISTableIDDataReader();
        GenericResource resource = reader.executeQuery();
        TableAssociationResource tableAssociations = null;
        if (resource != null) {
            tableAssociations = new TableAssociationResource(resource);
        }
        return tableAssociations;
    }

    public boolean addNewAssociation(String dataFlowKey, String tabularResourceID, String tableID) {
        logger.debug("Updating associations");
        logger.debug("Adding tabular resource id " + tabularResourceID + " table id " + tableID + " for dataflow " + dataFlowKey);
        TableAssociationResource tableAssociations = this.getTableAssociationResource();
        ISDataWriter dataWriter = null;
        boolean response = false;
        if (tableAssociations == null) {
            logger.debug("Data not present for this scope: creating new data");
            dataWriter = new ISDataWriter();
            dataWriter.addAssociation(dataFlowKey, tabularResourceID, tableID);
            response = dataWriter.commit();
        } else if (tableAssociations.getAssociationsTable().get(dataFlowKey) == null) {
            logger.debug("Current data flow not present: creating a new one...");
            dataWriter = new ISDataWriter(tableAssociations);
            dataWriter.addAssociation(dataFlowKey, tabularResourceID, tableID);
            response = dataWriter.commit();
        } else {
            logger.debug("Data already present for this data flow: nothing to do");
            response = true;
        }
        logger.debug("Final result " + response);
        return response;
    }

    public static String getDataFlowKey(String dataFlowAgency, String dataFlowId, String dataFlowVersion) {
        StringBuilder keyBuilder = new StringBuilder(dataFlowAgency);
        keyBuilder.append('.').append(dataFlowId).append('.').append(dataFlowVersion);
        String key = keyBuilder.toString();
        logger.debug("Key " + key);
        return key;
    }
}

