/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.api.model.versioning;

public class Version
implements Comparable<Version> {
    private int[] numericElements;
    private String version;
    private String stringElement;
    public static final String ALL = "all";
    public static final String LATEST = "latest";

    public Version(String versionString) {
        if (versionString == null || versionString.trim().length() == 0) {
            this.numericElements = new int[1];
            this.stringElement = "";
            this.version = "0";
        } else {
            this.version = versionString;
            String[] versionElements = versionString.split("-");
            this.stringElement = versionElements.length > 1 ? versionElements[1] : "";
            String[] versionNumbers = versionElements[0].split("\\.");
            this.numericElements = new int[versionNumbers.length];
            int i = 0;
            while (i < versionNumbers.length) {
                this.numericElements[i] = Integer.parseInt(versionNumbers[i]);
                ++i;
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(Version version) {
        int lenght1 = this.numericElements.length;
        int lenght2 = version.numericElements.length;
        int comparisonLenght = lenght1 <= lenght2 ? lenght1 : lenght2;
        int i = 0;
        while (i < comparisonLenght) {
            if (this.numericElements[i] < version.numericElements[i]) {
                return -1;
            }
            if (this.numericElements[i] > version.numericElements[i]) {
                return 1;
            }
            ++i;
        }
        int y = comparisonLenght;
        while (y < lenght1) {
            if (this.numericElements[y] > 0) {
                return 1;
            }
            ++y;
        }
        y = comparisonLenght;
        while (y < lenght2) {
            if (version.numericElements[y] > 0) {
                return -1;
            }
            ++y;
        }
        if (this.stringElement.trim().length() > 0 && version.stringElement.trim().length() == 0) {
            return 1;
        }
        if (this.stringElement.trim().length() == 0 && version.stringElement.trim().length() > 0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.version;
    }
}

