/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.impl.model;

import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.impl.model.SDMXRegistryDescriptorImpl;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeSDMXRegistryDescriptor
implements SDMXRegistryDescriptor {
    Logger logger = LoggerFactory.getLogger(GCubeSDMXRegistryDescriptor.class);
    private boolean dataRetrieved = false;
    private SDMXRegistryDescriptor delegate;

    public String getRest_url_V2_1() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getRest_url_V2_1();
    }

    public String getRest_url_V2() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getRest_url_V2();
    }

    public String getRest_url_V1() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getRest_url_V1();
    }

    public String getSoap_url_V2_1() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getSoap_url_V2_1();
    }

    public String getSoap_url_V2() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getSoap_url_V2();
    }

    public String getSoap_url_V1() {
        if (!this.dataRetrieved) {
            this.delegate = this.retrieveData();
        }
        return this.delegate.getSoap_url_V2();
    }

    private SDMXRegistryDescriptor retrieveData() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        String scope = ScopeProvider.instance.get();
        if (scope == null || scope.isEmpty()) {
            this.logger.error("No scope provided, unable to retrieve SDMX registry");
            return null;
        }
        this.logger.debug("Looking for SDMXRegistry resources on scope: " + scope);
        query.addCondition("$resource/Profile/Category/text() eq 'SDMX'");
        query.addCondition("$resource/Profile/Name/text() eq 'SDMXRegistry'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 1 || resources.isEmpty()) {
            this.logger.error("Invalid number of SDMX registry resources found: " + resources.size());
            return null;
        }
        SDMXRegistryDescriptorImpl registry = new SDMXRegistryDescriptorImpl();
        for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)resources.get(0)).profile().accessPoints()) {
            this.logger.trace("Retrieved " + ap.name() + ": " + ap.address());
            if (ap.name().equals(RegistryInterfaceCode.RESTV1.toString())) {
                registry.setRest_url_V1(ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.RESTV2.toString())) {
                registry.setRest_url_V2(ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.RESTV2_1.toString())) {
                registry.setRest_url_V2_1(ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.SOAPV1.toString())) {
                registry.setSoap_url_V1(ap.address());
            }
            if (ap.name().equals(RegistryInterfaceCode.SOAPV2.toString())) {
                registry.setSoap_url_V2(ap.address());
            }
            if (!ap.name().equals(RegistryInterfaceCode.SOAPV2_1.toString())) continue;
            registry.setSoap_url_V2_1(ap.address());
        }
        this.dataRetrieved = true;
        this.logger.debug("SDMX registry resource retrieved from IS");
        return registry;
    }

    static enum RegistryInterfaceCode {
        RESTV1,
        RESTV2,
        RESTV2_1,
        SOAPV1,
        SOAPV2,
        SOAPV2_1;

    }
}

