package org.gcube.data.publishing.gis.publisher.csquare;

import java.sql.SQLException;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.DataParsingException;
import org.gcube.data.streams.Stream;

public class CSquareConverterImpl  implements CSquareConverter {

	private CSquarePolygonsDBInterface dbInterface;
	private GCUBEScope scope;



	public CSquareConverterImpl(CSQuarePolygonDBDescriptor dbDescriptor,GCUBEScope scope) {
		super();
		this.dbInterface = new CSquarePolygonDBImpl(dbDescriptor);
		this.scope=scope;
	}




	@Override
	public Stream<GeometryPoint> convert(Stream<CSquarePoint> toConvert)throws DataParsingException{
		try{
			dbInterface.openSession();
			Table imported=dbInterface.streamToTable(toConvert);
			Table joined=dbInterface.joinToWorld(imported);		
			return dbInterface.streamTableRows(joined,scope);
		} catch (Exception e) {
			throw new DataParsingException(e);
		}finally{
			try {
				dbInterface.closeSession();
			} catch (SQLException e) {
				throw new DataParsingException(e);
			}
		}
	}


}
