/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher.csquare;

import java.sql.SQLException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.publishing.gis.publisher.csquare.CSQuarePolygonDBDescriptor;
import org.gcube.data.publishing.gis.publisher.csquare.CSquarePolygonDBImpl;
import org.gcube.data.publishing.gis.publisher.csquare.CSquarePolygonsDBInterface;
import org.gcube.data.publishing.gis.publisher.csquare.Table;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.DataParsingException;
import org.gcube.data.streams.Stream;

public class CSquareConverterImpl
implements CSquareConverter {
    private CSquarePolygonsDBInterface dbInterface;
    private GCUBEScope scope;

    public CSquareConverterImpl(CSQuarePolygonDBDescriptor dbDescriptor, GCUBEScope scope) {
        this.dbInterface = new CSquarePolygonDBImpl(dbDescriptor);
        this.scope = scope;
    }

    public Stream<GeometryPoint> convert(Stream<CSquarePoint> toConvert) throws DataParsingException {
        try {
            this.dbInterface.openSession();
            Table imported = this.dbInterface.streamToTable(toConvert);
            Table joined = this.dbInterface.joinToWorld(imported);
            Stream<GeometryPoint> stream = this.dbInterface.streamTableRows(joined, this.scope);
            return stream;
        }
        catch (Exception e) {
            throw new DataParsingException((Throwable)e);
        }
        finally {
            try {
                this.dbInterface.closeSession();
            }
            catch (SQLException e) {
                throw new DataParsingException((Throwable)e);
            }
        }
    }
}

