/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.UUID;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.MapItemType;
import org.gcube.common.core.types.StringMap;
import org.gcube.common.core.types.VOID;
import org.gcube.data.gis.publisher.stubs.DestinationInternalFault;
import org.gcube.data.gis.publisher.stubs.DestinationTypeNotSupportedFault;
import org.gcube.data.gis.publisher.stubs.DestinationUnreachableFault;
import org.gcube.data.gis.publisher.stubs.GISType;
import org.gcube.data.gis.publisher.stubs.IncorrectDataTypeFault;
import org.gcube.data.gis.publisher.stubs.PublishDataRequestType;
import org.gcube.data.gis.publisher.stubs.PublisherPortType;
import org.gcube.data.publishing.gis.publisher.PluginManager;
import org.gcube.data.publishing.gis.publisher.ServiceContext;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CoordinatePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISFile;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.StreamedGISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.DataParsingException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.NotSupportedDataTypeException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.RepositoryTypeNotSupportedException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.UnreachableDestinationException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.GISRequestConfiguration;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISDataType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISFileType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISRepositoryType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.GISXstream;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.ResultGenerator;
import org.gcube.data.publishing.gis.publisher.plugins.InteractionWrapper;
import org.gcube.data.publishing.gis.publisher.reports.StoredReport;
import org.gcube.data.publishing.gis.publisher.stubs.utils.RSWrapper;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;

public class PublisherPT
extends GCUBEPortType
implements PublisherPortType {
    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String publishData(PublishDataRequestType request) throws RemoteException, GCUBEFault, DestinationUnreachableFault, IncorrectDataTypeFault, DestinationInternalFault, DestinationTypeNotSupportedFault {
        try {
            PipedStream stream;
            GISRequestConfiguration config = (GISRequestConfiguration)GISXstream.get().fromXML(request.getSerializedConfiguration());
            this.logger.debug((Object)("Serving request " + config + ", data URI : " + request.getDataLocator() + ", data type " + request.getDataType()));
            StreamedGISData data = null;
            if (request.getDataType().equals((Object)GISType.COORD_STREAM)) {
                stream = Streams.pipe((Stream)Streams.convert((URI)new URI(request.getDataLocator())).of(GenericRecord.class).withDefaults()).through((Generator)new ResultGenerator());
                data = new StreamedGISData((Stream)stream, CoordinatePoint.class);
            } else if (request.getDataType().equals((Object)GISType.CSQUARE_STREAM)) {
                stream = Streams.pipe((Stream)Streams.convert((URI)new URI(request.getDataLocator())).of(GenericRecord.class).withDefaults()).through((Generator)new ResultGenerator());
                data = new StreamedGISData((Stream)stream, CSquarePoint.class);
            } else {
                GISFileType fileType = GISFileType.NETCDF;
                if (request.getDataType().equals((Object)GISType.GEOTIFF)) {
                    fileType = GISFileType.GEOTIFF;
                }
                data = new GISFile(RSWrapper.getStreamFromLocator((URI)new URI(request.getDataLocator())), fileType);
            }
            GCUBEScope scope = ServiceContext.getContext().getScope();
            InteractionWrapper wrapper = PluginManager.get(scope).getInteractionPlugin(config.getRepositoryDestination());
            return wrapper.publishData((GISData)data, config).getId().toString();
        }
        catch (RepositoryTypeNotSupportedException e) {
            this.logger.error((Object)"Repository type not found ", (Throwable)e);
            throw new DestinationTypeNotSupportedFault();
        }
        catch (DataParsingException e) {
            this.logger.error((Object)"Unable to parse data", (Throwable)e);
            throw new IncorrectDataTypeFault();
        }
        catch (NotSupportedDataTypeException e) {
            this.logger.error((Object)"Plugin doesn't support passed data type");
            throw new IncorrectDataTypeFault();
        }
        catch (UnreachableDestinationException e) {
            this.logger.error((Object)"Selected destination is down", (Throwable)e);
            throw new DestinationUnreachableFault();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Unexpected Exception", t);
            throw new GCUBEFault();
        }
    }

    public StringMap getCapabilities(VOID request) throws RemoteException, GCUBEFault {
        ArrayList<MapItemType> toReturnList = new ArrayList<MapItemType>();
        GCUBEScope scope = ServiceContext.getContext().getScope();
        PluginManager pManager = PluginManager.get(scope);
        for (GISRepositoryType repoType : pManager.getHandledRepositories()) {
            for (GISDataType dataType : pManager.getHandledDataType(repoType)) {
                toReturnList.add(new MapItemType(repoType.toString(), dataType.toString()));
            }
        }
        return new StringMap(toReturnList.toArray(new MapItemType[toReturnList.size()]));
    }

    public String getPublishingReport(String request) throws RemoteException, GCUBEFault {
        try {
            StoredReport report = (StoredReport)ServiceContext.getContext().getReportDao().queryForId((Object)UUID.fromString(request));
            return report.getSerializedReport();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Unexpected Exception", t);
            throw new GCUBEFault();
        }
    }
}

