package org.gcube.data.publishing.gis.publisher.plugin.fwk.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias("CoordinatePoint")
public class CoordinatePoint implements GeoPoint {
	
	@XStreamAsAttribute
	private double latitude=0d;
	@XStreamAsAttribute
	private double longitude=0d;
	
	private Map<String,Serializable> attributes=new HashMap<String, Serializable>();
	
	public CoordinatePoint() {
		// TODO Auto-generated constructor stub
	}

	public CoordinatePoint(double latitude, double longitude,
			Map<String, Serializable> attributes) {
		super();
		this.latitude = latitude;
		this.longitude = longitude;
		this.attributes = attributes;
	}

	/**
	 * @return the latitude
	 */
	public double getLatitude() {
		return latitude;
	}

	/**
	 * @param latitude the latitude to set
	 */
	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}

	/**
	 * @return the longitude
	 */
	public double getLongitude() {
		return longitude;
	}

	/**
	 * @param longitude the longitude to set
	 */
	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}

	/**
	 * @return the attributes
	 */
	public Map<String, Serializable> getAttributes() {
		return attributes;
	}

	/**
	 * @param attributes the attributes to set
	 */
	public void setAttributes(Map<String, Serializable> attributes) {
		this.attributes = attributes;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CoordinatePoint [latitude=");
		builder.append(latitude);
		builder.append(", longitude=");
		builder.append(longitude);
		builder.append(", attributes=");
		builder.append(attributes);
		builder.append("]");
		return builder.toString();
	}
	
	
	
}
