/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.GISXstream;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper.AbstractWrapper;

public class ResultWrapper<T>
extends AbstractWrapper<T> {
    public int count = 0;
    private static XStream xstream = GISXstream.get();
    GCUBELog logger = new GCUBELog(ResultWrapper.class);
    private int links;
    private RecordWriter<GenericRecord> writer = null;

    public ResultWrapper(GCUBEScope scope) throws Exception {
        StringFieldDefinition fieldDefinition = new StringFieldDefinition("result");
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fieldDefinition})};
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), defs, 200, 2, 0.5f, 5L, TimeUnit.MINUTES);
        this.links = 0;
    }

    @Override
    public String getLocator() throws Exception {
        return this.writer.getLocator().toString();
    }

    @Override
    public synchronized boolean add(T input) throws Exception {
        GenericRecord gr = new GenericRecord();
        gr.setFields((Field[])new StringField[]{new StringField(xstream.toXML(input))});
        return this.writer.put((Record)gr, 5L, TimeUnit.MINUTES);
    }

    @Override
    public synchronized void unregister() throws Exception {
        this.logger.trace((Object)("unregistering " + this.links));
        if (this.links > 1) {
            --this.links;
        } else {
            this.links = 0;
            this.close();
        }
    }

    @Override
    public synchronized void register() {
        this.logger.trace((Object)("registering " + this.links));
        ++this.links;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }

    @Override
    public boolean isClosed() {
        return this.writer.getStatus() == IBuffer.Status.Dispose || this.writer.getStatus() == IBuffer.Status.Close;
    }

    static {
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(3050, 3100));
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), ports, true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }
}

