/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher.plugin.fwk.model;

import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CoordinatePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeoPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.NotSupportedDataTypeException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISStreamedType;
import org.gcube.data.streams.Stream;

public class StreamedGISData<T extends GeoPoint>
implements GISData {
    private Stream<T> stream;
    private Class<T> clazz;

    public StreamedGISData(Stream<T> stream, Class<T> handledPointClass) throws NotSupportedDataTypeException {
        this.stream = stream;
        this.clazz = handledPointClass;
        if (!(this.clazz.isAssignableFrom(CSquarePoint.class) || this.clazz.isAssignableFrom(CoordinatePoint.class) || this.clazz.isAssignableFrom(GeometryPoint.class))) {
            throw new NotSupportedDataTypeException();
        }
    }

    @Override
    public GISStreamedType getType() {
        if (this.clazz.isAssignableFrom(CSquarePoint.class)) {
            return GISStreamedType.CSQUARE_POINTS;
        }
        return GISStreamedType.COORDINATE_POINTS;
    }

    public Class<T> getStreamedType() {
        return this.clazz;
    }

    @Override
    public String getURI() {
        return this.stream.locator().toString();
    }

    public Stream<T> getStream() {
        return this.stream;
    }
}

