package org.gcube.data.publishing.gis.publisher.plugin.fwk.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;



@XStreamAlias("CSQUAREPoint")
public class CSquarePoint implements GeoPoint{
	
	@XStreamAsAttribute
	private String cSquareCode;
	private Map<String,Serializable> attributes=new HashMap<String, Serializable>();
	
	public CSquarePoint() {
		// TODO Auto-generated constructor stub
	}

	public CSquarePoint(String cSquareCode, Map<String, Serializable> attributes) {
		super();
		this.cSquareCode = cSquareCode;
		this.attributes = attributes;
	}

	/**
	 * @return the cSquareCode
	 */
	public String getcSquareCode() {
		return cSquareCode;
	}

	/**
	 * @param cSquareCode the cSquareCode to set
	 */
	public void setcSquareCode(String cSquareCode) {
		this.cSquareCode = cSquareCode;
	}

	/**
	 * @return the attributes
	 */
	public Map<String, Serializable> getAttributes() {
		return attributes;
	}

	/**
	 * @param attributes the attributes to set
	 */
	public void setAttributes(Map<String, Serializable> attributes) {
		this.attributes = attributes;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CSquarePoint [cSquareCode=");
		builder.append(cSquareCode);
		builder.append(", attributes=");
		builder.append(attributes);
		builder.append("]");
		return builder.toString();
	}
	
	
}
