package org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;


public class LocalWrapper<T> extends AbstractWrapper<T> {

	private String locator;
		
	private ArrayBlockingQueue<T> queue;
	
	private int links;
	
	
	public LocalWrapper() {
		super();
		this.locator = UUID.randomUUID().toString();
		this.queue = new ArrayBlockingQueue<T>(100);
	}

	public LocalWrapper(int queueSize) {
		super();
		this.locator = UUID.randomUUID().toString();
		this.queue = new ArrayBlockingQueue<T>(queueSize);
	}
	
	@Override
	public String getLocator() throws Exception {
		return this.locator;
	}

	@Override
	public synchronized boolean add(T input) throws Exception {
		return this.queue.offer(input, 60,TimeUnit.SECONDS);
	}

	@Override
	public void close() throws Exception {}

	public ArrayBlockingQueue<T> getQueue(){
		return queue;
	}
	
	@Override
	public synchronized void unregister() throws Exception{
		if (links>1) links--;
		else{
			links =0;
			this.close();
		}
	}
	
	@Override
	public synchronized void register(){
		this.links++;
	}

	@Override
	public boolean isClosed() {
		return false;
	}
	
	
	
}
