package org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper;

import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.utils.GISXstream;

import com.thoughtworks.xstream.XStream;


public class ResultWrapper<T> extends AbstractWrapper<T>{ 

	public int count= 0;
	
	private static XStream xstream=GISXstream.get();
	
	static{
		List<PortRange> ports=new ArrayList<PortRange>(); //The ports that the TCPConnection manager should use
		ports.add(new PortRange(3050, 3100));            
		TCPConnectionManager.Init(
		  new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), //The hostname by which the machine is reachable 
		    ports,                                    //The ports that can be used by the connection manager
		    true                                      //If no port ranges were provided, or none of them could be used, use a random available port
		));
		TCPConnectionManager.RegisterEntry(new TCPConnectionHandler());      //Register the handler for the gRS2 incoming requests
		TCPConnectionManager.RegisterEntry(new TCPStoreConnectionHandler());
	}
	
	GCUBELog logger= new GCUBELog(ResultWrapper.class);
	
	private int links;
	
	private RecordWriter<GenericRecord> writer=null;
	
	public ResultWrapper(GCUBEScope scope) throws Exception{
		StringFieldDefinition fieldDefinition = new StringFieldDefinition("result");
		RecordDefinition[] defs=new RecordDefinition[]{          //A gRS can contain a number of different record definitions
		        new GenericRecordDefinition((new FieldDefinition[] { //A record can contain a number of different field definitions
		        		fieldDefinition				        //The definition of the field
		      }))
		    };
		 this.writer=new RecordWriter<GenericRecord>(
		       new TCPWriterProxy(), //The proxy that defines the way the writer can be accessed
		       defs,   //The definitions of the records the gRS handles
		       200,              //The capacity of the underlying synchronization buffer
		       2,               //The maximum number of parallel records that can be concurrently accessed on partial transfer  
		       0.5f,            //The maximum fraction of the buffer that should be transfered during mirroring 
		       2,              //The timeout in time units after which an inactive gRS can be disposed  
		       TimeUnit.MINUTES //The time unit in timeout after which an inactive gRS can be disposed
		 );
		 
		 this.links = 0;
	}
	
	public String getLocator() throws Exception{
		return this.writer.getLocator().toString();
	}
	
	public synchronized boolean add(T input) throws Exception{
		GenericRecord gr=new GenericRecord();
		gr.setFields(new StringField[]{new StringField(xstream.toXML(input))});
		return writer.put(gr,5,TimeUnit.MINUTES);
	}
		
	public synchronized void unregister() throws Exception{
		logger.trace("unregistering "+links);
		if (links>1) links--;
		else{
			links =0;
			this.close();
		}
	}
	
	
	
	public synchronized void register(){
		logger.trace("registering "+links);
		this.links++;
	}
	
	public void close() throws Exception{
		this.writer.close();
	}

	@Override
	public boolean isClosed() {
		return (writer.getStatus()==Status.Dispose || writer.getStatus()==Status.Close);
	}
	
}
