package org.gcube.data.publishing.gis.publisher.plugin.fwk.writers;


import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.writers.rswrapper.AbstractWrapper;
import org.gcube.data.streams.exceptions.StreamException;


public class Writer<F> extends AbstractWriter<F>{

	private GCUBELog logger= new GCUBELog(Writer.class);
		
	private WriterManager<F> manager = new DefaultWriter();
	
		
	public Writer(AbstractWrapper<F> wrapper) {
		super(wrapper);
	}
	
	public Writer(AbstractWrapper<F> wrapper, WriterManager<F> manager) {
		super(wrapper);
		this.manager = manager;
	}

	@Override
	public synchronized boolean put(F t){
		if(this.getWrapper().isClosed()) return false;
		if (manager.filter(t)){
			try{
				getWrapper().add(manager.enrich(t));
				return true;
			}catch (Exception e) {
				logger.warn("error putting a result in the Writer",e);
				return false;
			}
		} else {
			logger.debug("a result has been discarded");
			return false;
		}

	}

	
	public class DefaultWriter extends WriterManager<F>{}


	@Override
	public boolean put(StreamException error) {
		return true;
	}
	
	

}
