package org.gcube.data.publishing.gis.publisher.model.response;

import java.util.HashMap;
import java.util.Map;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias("PublishingReport")
public class PublishingReport {

	@XStreamAsAttribute
	private PublishingStatus status;
	private Map<String,String> errorMessages=new HashMap<String, String>();
	
	private HashMap<String,GeneratedLayerReport> generatedLayers=new HashMap<String, GeneratedLayerReport>();
	
	private HashMap<String,GeneratedStyleReport> generatedStyles=new HashMap<String, GeneratedStyleReport>();
	
	private HashMap<String,GeneratedWMSGroupReport> generatedGroups=new HashMap<String, GeneratedWMSGroupReport>();
	
	public PublishingReport() {
		// TODO Auto-generated constructor stub
	}

	public PublishingReport(PublishingStatus status,
			Map<String, String> errorMessages,
			HashMap<String, GeneratedLayerReport> generatedLayers,
			HashMap<String, GeneratedStyleReport> generatedStyles,
			HashMap<String, GeneratedWMSGroupReport> generatedGroups) {
		super();
		this.status = status;
		this.errorMessages = errorMessages;
		this.generatedLayers = generatedLayers;
		this.generatedStyles = generatedStyles;
		this.generatedGroups = generatedGroups;
	}

	/**
	 * @return the status
	 */
	public PublishingStatus getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(PublishingStatus status) {
		this.status = status;
	}

	/**
	 * @return the errorMessages
	 */
	public Map<String, String> getErrorMessages() {
		return errorMessages;
	}

	/**
	 * @param errorMessages the errorMessages to set
	 */
	public void setErrorMessages(Map<String, String> errorMessages) {
		this.errorMessages = errorMessages;
	}

	/**
	 * @return the generatedLayers
	 */
	public HashMap<String, GeneratedLayerReport> getGeneratedLayers() {
		return generatedLayers;
	}

	/**
	 * @param generatedLayers the generatedLayers to set
	 */
	public void setGeneratedLayers(
			HashMap<String, GeneratedLayerReport> generatedLayers) {
		this.generatedLayers = generatedLayers;
	}

	/**
	 * @return the generatedStyles
	 */
	public HashMap<String, GeneratedStyleReport> getGeneratedStyles() {
		return generatedStyles;
	}

	/**
	 * @param generatedStyles the generatedStyles to set
	 */
	public void setGeneratedStyles(
			HashMap<String, GeneratedStyleReport> generatedStyles) {
		this.generatedStyles = generatedStyles;
	}

	/**
	 * @return the generatedGroups
	 */
	public HashMap<String, GeneratedWMSGroupReport> getGeneratedGroups() {
		return generatedGroups;
	}

	/**
	 * @param generatedGroups the generatedGroups to set
	 */
	public void setGeneratedGroups(
			HashMap<String, GeneratedWMSGroupReport> generatedGroups) {
		this.generatedGroups = generatedGroups;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("PublishingReport [status=");
		builder.append(status);
		builder.append(", errorMessages=");
		builder.append(errorMessages);
		builder.append(", generatedLayers=");
		builder.append(generatedLayers);
		builder.append(", generatedStyles=");
		builder.append(generatedStyles);
		builder.append(", generatedGroups=");
		builder.append(generatedGroups);
		builder.append("]");
		return builder.toString();
	}

	
	
	
	
	
}
