/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.implementation.validations.validators;

import java.io.Serializable;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;

public class ValidIntegerValidator
implements FieldAction {
    private static final String ERROR = String.format("Not Instance of %s", Integer.class.getSimpleName());

    @Override
    public Serializable validate(String key, Serializable value, Record record) throws InvalidValueException {
        if (value instanceof Integer) {
            return value;
        }
        try {
            Integer integerObj = Integer.valueOf((String)((Object)value));
            if (integerObj != null) {
                return integerObj;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Double doubleObj = Double.valueOf((String)((Object)value));
            if (doubleObj != null) {
                return Integer.valueOf(doubleObj.intValue());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new InvalidValueException(ERROR);
    }
}

