/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.DefaultPersitenceExecutor;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.gcube.documentstore.persistence.PersistenceBackendMonitor;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackend.class);
    protected FallbackPersistenceBackend fallbackPersistence;
    protected AggregationScheduler aggregationScheduler;
    protected PersistenceBackendMonitor persistenceBackendMonitor;
    public static final Integer MAX_FALLBACK = 3;
    protected static Integer countFallback;
    protected boolean closed;

    protected PersistenceBackend() {
        if (!(this instanceof FallbackPersistenceBackend)) {
            this.persistenceBackendMonitor = new PersistenceBackendMonitor(this);
        }
        countFallback = 0;
        this.closed = true;
    }

    protected PersistenceBackend(FallbackPersistenceBackend fallback) {
        this();
        logger.trace("PersistenceBackend-");
        this.fallbackPersistence = fallback;
        this.aggregationScheduler = AggregationScheduler.newInstance(new DefaultPersitenceExecutor(this), "FALLBACK");
    }

    public FallbackPersistenceBackend getFallbackPersistence() {
        return this.fallbackPersistence;
    }

    protected void setFallback(FallbackPersistenceBackend fallback) {
        this.fallbackPersistence = fallback;
    }

    public AggregationScheduler getAggregationScheduler() {
        return this.aggregationScheduler;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(PersistenceBackendConfiguration var1) throws Exception;

    protected abstract void reallyAccount(Record var1) throws Exception;

    protected void accountWithFallback(Record ... records) {
        String persistenceName = this.getClass().getSimpleName();
        logger.trace("Going to account {} using {} : {}", new Object[]{Arrays.toString(records), persistenceName, this});
        for (Record record : records) {
            try {
                logger.trace("Going to account {} using {} : {}", new Object[]{record, persistenceName, this});
                this.reallyAccount(record);
                logger.trace("{} accounted succesfully from {}.", (Object)record.toString(), (Object)persistenceName);
            }
            catch (Exception e) {
                if (!(this instanceof FallbackPersistenceBackend) && e.getCause() != null && e.getCause() instanceof TimeoutException) {
                    logger.error("TimeoutException number:{} to  {}.", (Object)countFallback, (Object)MAX_FALLBACK);
                    Integer n = countFallback;
                    Integer n2 = countFallback = Integer.valueOf(countFallback + 1);
                    if (countFallback.equals(MAX_FALLBACK)) {
                        PersistenceBackendFactory.renew(this);
                        countFallback = 0;
                    }
                } else {
                    logger.trace("Fallback is same instance:{}" + this.getClass().getSimpleName());
                }
                try {
                    String fallabackPersistenceName = FallbackPersistenceBackend.class.getSimpleName();
                    logger.error("{} was not accounted succesfully from {}. Trying to use {}.", new Object[]{record.toString(), persistenceName, fallabackPersistenceName, e});
                    this.fallbackPersistence.reallyAccount(record);
                    logger.trace("{} accounted succesfully from {}", (Object)record.toString(), (Object)fallabackPersistenceName);
                }
                catch (Exception ex) {
                    logger.error("{} was not accounted at all", (Object)record.toString(), (Object)e);
                }
            }
        }
    }

    protected void accountValidateAggregate(Record record, boolean validate, boolean aggregate) {
        try {
            logger.trace("Received {} to account : {}", (Object)record.getClass().getSimpleName(), (Object)record);
            if (validate) {
                record.validate();
                logger.trace("{} {} valid", (Object)record.getClass().getSimpleName(), (Object)record);
            }
            if (aggregate) {
                try {
                    this.aggregationScheduler.aggregate(record, new DefaultPersitenceExecutor(this));
                }
                catch (Exception e) {
                    this.accountWithFallback(record);
                }
            } else {
                this.accountWithFallback(record);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Error recording {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
    }

    public void account(final Record record) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PersistenceBackend.this.accountValidateAggregate(record, true, true);
            }
        };
        ExecutorUtils.threadPool.execute(runnable);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        this.aggregationScheduler.flush(new DefaultPersitenceExecutor(this));
    }

    public boolean isOpen() {
        return !this.closed;
    }

    protected void setOpen() {
        this.closed = false;
    }

    public abstract void close() throws Exception;
}

