/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceExecutor;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.BufferAggregationScheduler;
import org.gcube.documentstore.records.implementation.ConfigurationGetPropertyValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregationScheduler
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(AggregationScheduler.class);
    protected int totalBufferedRecords = 0;
    protected Map<String, List<Record>> bufferedRecords = new HashMap<String, List<Record>>();
    protected final PersistenceExecutor persistenceExecutor;
    public static final int INITIAL_DELAY = 30;
    public static Integer initialDelaySet;
    public static final int DELAY = 30;
    public static Integer delaySet;
    public static final TimeUnit TIME_UNIT;
    public static final String AGGREGATION_SCHEDULER_TIME = "AggregationSchedulerTime";
    public static final String BUFFER_RECORD_TIME = "BufferRecordTime";
    public static final String BUFFER_RECORD_NUMBER = "BufferRecordNumber";
    public static long TIME_RELOAD_CONFIGURATION;
    public static long TIME_LOAD_CONFIGURATION;
    protected static final int MAX_RECORDS_NUMBER = 100;
    protected static int maxRecordsNumberSet;
    protected static final long OLD_RECORD_MAX_TIME_ELAPSED = 1800000L;
    protected static long OldRecordMaxTimeElapsedSet;
    protected ScheduledFuture<?> future = null;

    public static AggregationScheduler newInstance(PersistenceExecutor persistenceExecutor) {
        return new BufferAggregationScheduler(persistenceExecutor);
    }

    public static AggregationScheduler newInstance(PersistenceExecutor persistenceExecutor, PersistenceBackendConfiguration configuration) throws NumberFormatException, Exception {
        ConfigurationGetPropertyValues properties = new ConfigurationGetPropertyValues();
        Properties prop = properties.getPropValues();
        Integer delay = null;
        Integer maxRecordNumber = null;
        Integer maxRecordTime = null;
        if (prop == null) {
            logger.trace("Configuration from service end point");
            try {
                delay = Integer.parseInt(configuration.getProperty(AGGREGATION_SCHEDULER_TIME));
            }
            catch (Exception e) {
                logger.trace("Configuration from service end point, not found delay value");
            }
            try {
                maxRecordTime = Integer.parseInt(configuration.getProperty(BUFFER_RECORD_TIME));
            }
            catch (Exception e) {
                logger.trace("Configuration from service end point, not found maxRecordTime value");
            }
            try {
                maxRecordNumber = Integer.parseInt(configuration.getProperty(BUFFER_RECORD_NUMBER));
            }
            catch (Exception e) {
                logger.trace("Configuration from service end point, not found maxRecordNumber value");
            }
        } else {
            logger.trace("Configuration from properties file");
            try {
                delay = Integer.parseInt(prop.getProperty("delay"));
            }
            catch (Exception e) {
                logger.trace("Configuration from properties file, not found a delay value");
            }
            try {
                maxRecordNumber = Integer.parseInt(prop.getProperty("maxrecordnumber"));
            }
            catch (Exception e) {
                logger.trace("Configuration from properties file, not found a maxRecordNumber value");
            }
            try {
                maxRecordTime = Integer.parseInt(prop.getProperty("maxtimenumber"));
            }
            catch (Exception e) {
                logger.trace("Configuration from properties file, not found a maxRecordTime value");
            }
        }
        if (delay != null) {
            delaySet = delay;
            initialDelaySet = delay;
        } else {
            delaySet = 30;
            initialDelaySet = 30;
        }
        maxRecordsNumberSet = maxRecordNumber != null ? maxRecordNumber : 100;
        OldRecordMaxTimeElapsedSet = maxRecordTime != null ? (long)(maxRecordTime * 1000 * 60) : 1800000L;
        TIME_LOAD_CONFIGURATION = Calendar.getInstance().getTimeInMillis();
        logger.trace("Start Instance for time load configuration {}", (Object)TIME_LOAD_CONFIGURATION);
        return new BufferAggregationScheduler(persistenceExecutor);
    }

    protected AggregationScheduler(PersistenceExecutor persistenceExecutor) {
        this.persistenceExecutor = persistenceExecutor;
        if (initialDelaySet == null) {
            initialDelaySet = 30;
        }
        if (delaySet == null) {
            delaySet = 30;
        }
        if (initialDelaySet == 0 || delaySet == 0) {
            initialDelaySet = 1;
            delaySet = 1;
        }
        this.scheduleTask();
        logger.trace("Thread scheduler created in {} ", (Object)this.toString());
        logger.trace("Reload configuration every {}", (Object)TIME_RELOAD_CONFIGURATION);
        logger.trace("Aggregated for max record {}", (Object)maxRecordsNumberSet);
        logger.trace("Aggregated for max time {}", (Object)OldRecordMaxTimeElapsedSet);
    }

    private void scheduleTask() {
        if (this.future == null) {
            this.future = ExecutorUtils.scheduler.scheduleAtFixedRate(this, initialDelaySet.intValue(), delaySet.intValue(), TIME_UNIT);
        } else if (this.future.getDelay(TIME_UNIT) != (long)delaySet.intValue()) {
            this.future.cancel(false);
            this.future = ExecutorUtils.scheduler.scheduleAtFixedRate(this, delaySet.intValue(), delaySet.intValue(), TIME_UNIT);
        }
    }

    protected static AggregatedRecord instantiateAggregatedRecord(Record record) throws Exception {
        String recordType = record.getRecordType();
        Class<AggregatedRecord<?, ?>> clz = RecordUtility.getAggregatedRecordClass(recordType);
        Class[] argTypes = new Class[]{record.getClass()};
        Constructor<AggregatedRecord<?, ?>> constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{record};
        return constructor.newInstance(arguments);
    }

    public static AggregatedRecord getAggregatedRecord(Record record) throws Exception {
        AggregatedRecord aggregatedRecord = record instanceof AggregatedRecord ? (AggregatedRecord)record : AggregationScheduler.instantiateAggregatedRecord(record);
        return aggregatedRecord;
    }

    protected void madeAggregation(Record record) {
        String recordType = record.getRecordType();
        if (this.bufferedRecords.containsKey(recordType)) {
            List<Record> records = this.bufferedRecords.get(recordType);
            boolean found = false;
            for (Record bufferedRecord : records) {
                if (!(bufferedRecord instanceof AggregatedRecord)) continue;
                try {
                    AggregatedRecord bufferedAggregatedRecord = (AggregatedRecord)bufferedRecord;
                    if (record instanceof AggregatedRecord) {
                        bufferedAggregatedRecord.aggregate((AggregatedRecord)record);
                    } else {
                        bufferedAggregatedRecord.aggregate(record);
                    }
                    logger.trace("Aggregated Record is {}", (Object)bufferedAggregatedRecord);
                    found = true;
                    break;
                }
                catch (NotAggregatableRecordsExceptions e) {
                    logger.trace("{} is not usable for aggregation", (Object)bufferedRecord);
                }
            }
            if (!found) {
                try {
                    records.add(AggregationScheduler.getAggregatedRecord(record));
                }
                catch (Exception e) {
                    records.add(record);
                }
                ++this.totalBufferedRecords;
                return;
            }
        } else {
            ArrayList<Record> records = new ArrayList<Record>();
            try {
                records.add(AggregationScheduler.getAggregatedRecord(record));
            }
            catch (Exception e) {
                records.add(record);
            }
            ++this.totalBufferedRecords;
            this.bufferedRecords.put(recordType, records);
        }
    }

    public void flush(PersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(null, persistenceExecutor, true);
    }

    protected abstract void schedulerSpecificClear();

    protected void clear() {
        this.totalBufferedRecords = 0;
        this.bufferedRecords.clear();
        this.schedulerSpecificClear();
    }

    protected synchronized void aggregate(Record record, PersistenceExecutor persistenceExecutor, boolean forceFlush) throws Exception {
        long now;
        if (record != null) {
            this.madeAggregation(record);
        }
        if (this.isTimeToPersist(maxRecordsNumberSet, OldRecordMaxTimeElapsedSet) || forceFlush) {
            this.reallyFlush(persistenceExecutor);
        }
        if ((now = Calendar.getInstance().getTimeInMillis()) - TIME_LOAD_CONFIGURATION >= TIME_RELOAD_CONFIGURATION) {
            this.reloadConfiguration();
        }
    }

    protected void reloadConfiguration() throws Exception {
        new Thread(){

            @Override
            public void run() {
                Integer maxRecordTime;
                Integer maxRecordNumber;
                Integer delay;
                block20: {
                    delay = null;
                    maxRecordNumber = null;
                    maxRecordTime = null;
                    try {
                        ConfigurationGetPropertyValues properties = new ConfigurationGetPropertyValues();
                        Properties prop = properties.getPropValues();
                        if (prop != null) {
                            logger.trace("Reload Configuration from properties file");
                            try {
                                delay = Integer.parseInt(prop.getProperty("delay"));
                            }
                            catch (Exception e) {
                                logger.trace("Reload Configuration from properties file, not found delay value");
                            }
                            try {
                                maxRecordNumber = Integer.parseInt(prop.getProperty("maxrecordnumber"));
                            }
                            catch (Exception e) {
                                logger.trace("Reload Configuration from properties file, not found maxRecordNumber value");
                            }
                            try {
                                maxRecordTime = Integer.parseInt(prop.getProperty("maxtimenumber"));
                            }
                            catch (Exception e) {
                                logger.trace("Reload Configuration from properties file, not found maxRecordTime value");
                            }
                            break block20;
                        }
                        ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
                        PersistenceBackendConfiguration configuration = null;
                        for (PersistenceBackend found : serviceLoader) {
                            Class<?> foundClass = found.getClass();
                            try {
                                String foundClassName = foundClass.getSimpleName();
                                logger.trace("Testing {}", (Object)foundClassName);
                                configuration = PersistenceBackendConfiguration.getInstance(foundClass);
                                if (configuration == null) continue;
                                logger.debug("{} will be used.", (Object)foundClassName);
                            }
                            catch (Exception e) {
                                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), (Throwable)e);
                            }
                        }
                        if (configuration == null) break block20;
                        logger.trace("Reload Configuration from service end point");
                        try {
                            delay = Integer.parseInt(configuration.getProperty(AggregationScheduler.AGGREGATION_SCHEDULER_TIME));
                        }
                        catch (Exception e) {
                            logger.trace("Reload Configuration from service end point,not found delay value");
                        }
                        try {
                            maxRecordTime = Integer.parseInt(configuration.getProperty(AggregationScheduler.BUFFER_RECORD_TIME));
                        }
                        catch (Exception e) {
                            logger.trace("Reload Configuration from service end point,not found maxRecordTime value");
                        }
                        try {
                            maxRecordNumber = Integer.parseInt(configuration.getProperty(AggregationScheduler.BUFFER_RECORD_NUMBER));
                        }
                        catch (Exception e) {
                            logger.trace("Reload Configuration from service end point,not found maxRecordNumber value");
                        }
                    }
                    catch (Exception e) {
                        logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", e.getLocalizedMessage()), (Throwable)e);
                    }
                }
                if (delay != null) {
                    delaySet = delay;
                    initialDelaySet = delay;
                } else {
                    delaySet = 30;
                    initialDelaySet = 30;
                }
                maxRecordsNumberSet = maxRecordNumber != null ? maxRecordNumber : 100;
                OldRecordMaxTimeElapsedSet = maxRecordTime != null ? (long)(maxRecordTime * 1000 * 60) : 1800000L;
                TIME_LOAD_CONFIGURATION = Calendar.getInstance().getTimeInMillis();
                logger.trace("Aggregated for max record {}", (Object)maxRecordsNumberSet);
                logger.trace("Aggregated for max time {}", (Object)OldRecordMaxTimeElapsedSet);
            }
        }.start();
    }

    protected void reallyFlush(PersistenceExecutor persistenceExecutor) throws Exception {
        if (this.totalBufferedRecords == 0) {
            return;
        }
        Object[] recordToPersist = new Record[this.totalBufferedRecords];
        int i = 0;
        Collection<List<Record>> values = this.bufferedRecords.values();
        for (List<Record> records : values) {
            for (Record thisRecord : records) {
                recordToPersist[i] = thisRecord;
                ++i;
            }
        }
        logger.trace("reallyFlush It is time to persist buffered records {}", (Object)Arrays.toString(recordToPersist));
        persistenceExecutor.persist((Record[])recordToPersist);
        this.clear();
    }

    public void aggregate(Record record, PersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(record, persistenceExecutor, false);
    }

    protected abstract boolean isTimeToPersist(int var1, long var2);

    @Override
    public void run() {
        try {
            this.flush(this.persistenceExecutor);
        }
        catch (Exception e) {
            logger.error("Error flushing Buffered Records", (Throwable)e);
        }
        this.scheduleTask();
    }

    static {
        TIME_UNIT = TimeUnit.MINUTES;
        TIME_RELOAD_CONFIGURATION = 300000L;
        TIME_LOAD_CONFIGURATION = 0L;
    }
}

