/**
 * 
 */
package org.gcube.documentstore.records.aggregation;

import java.util.Calendar;
import java.util.ServiceLoader;


import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceExecutor;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 * This class implements a Simple Buffer with timeout strategy.
 * It buffer a predefined number of Records before invoking a persistence.
 */
public class BufferAggregationScheduler extends AggregationScheduler {


	public static final String BUFFER_RECORD_TIME="BufferRecordTime";
	public static final String BUFFER_RECORD_NUMBER="BufferRecordNumber";

	/**
	 * Define the MAX number of Record to buffer.
	 * TODO Get from configuration
	 */
	protected  static int MAX_RECORDS_NUMBER = 15;

	/**
	 * The Max amount of time elapsed form last record before after that
	 * the buffered record are persisted even if  
	 * TODO Get from configuration
	 */
	protected  static long OLD_RECORD_MAX_TIME_ELAPSED = 1000*60*5; // 5 min  

	protected boolean firstOfBuffer;
	protected long firstBufferedTime;

	public BufferAggregationScheduler(PersistenceExecutor persistenceExecutor){
		super(persistenceExecutor);
		this.firstOfBuffer = true;
	}

	@Override
	protected void schedulerSpecificClear(){
		firstOfBuffer = true;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isTimeToPersist(){
		long now = Calendar.getInstance().getTimeInMillis();



		ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
		for (PersistenceBackend found : serviceLoader) {
			Class<? extends PersistenceBackend> foundClass = found.getClass();
			try {
				String foundClassName = foundClass.getSimpleName();

				PersistenceBackendConfiguration configuration = PersistenceBackendConfiguration.getInstance(foundClass);
				if(configuration==null){
					continue;
				}
				else{
					Long maxRecordTime=Long.parseLong(configuration.getProperty(BUFFER_RECORD_TIME), 10); 
					OLD_RECORD_MAX_TIME_ELAPSED=maxRecordTime;
					
					int maxRecordNumber=Integer.parseInt(configuration.getProperty(BUFFER_RECORD_NUMBER));
					MAX_RECORDS_NUMBER=maxRecordNumber;
				}

			} catch (Exception e) {
				logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), e);
			}
		}






		if(firstOfBuffer){
			firstOfBuffer = false;
			firstBufferedTime = now;
		}

		if(totalBufferedRecords >= MAX_RECORDS_NUMBER){
			return true;
		}

		if((now - firstBufferedTime) >= OLD_RECORD_MAX_TIME_ELAPSED){
			return true;
		}

		return false;
	}


}
