/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.util.Calendar;
import java.util.ServiceLoader;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceExecutor;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;

public class BufferAggregationScheduler
extends AggregationScheduler {
    public static final String BUFFER_RECORD_TIME = "BufferRecordTime";
    public static final String BUFFER_RECORD_NUMBER = "BufferRecordNumber";
    protected static int MAX_RECORDS_NUMBER = 15;
    protected static long OLD_RECORD_MAX_TIME_ELAPSED = 300000L;
    protected boolean firstOfBuffer = true;
    protected long firstBufferedTime;

    public BufferAggregationScheduler(PersistenceExecutor persistenceExecutor) {
        super(persistenceExecutor);
    }

    @Override
    protected void schedulerSpecificClear() {
        this.firstOfBuffer = true;
    }

    @Override
    public boolean isTimeToPersist() {
        long now = Calendar.getInstance().getTimeInMillis();
        ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
        for (PersistenceBackend found : serviceLoader) {
            Class<?> foundClass = found.getClass();
            try {
                int maxRecordNumber;
                String foundClassName = foundClass.getSimpleName();
                PersistenceBackendConfiguration configuration = PersistenceBackendConfiguration.getInstance(foundClass);
                if (configuration == null) continue;
                Long maxRecordTime = Long.parseLong(configuration.getProperty(BUFFER_RECORD_TIME), 10);
                OLD_RECORD_MAX_TIME_ELAPSED = maxRecordTime;
                MAX_RECORDS_NUMBER = maxRecordNumber = Integer.parseInt(configuration.getProperty(BUFFER_RECORD_NUMBER));
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), (Throwable)e);
            }
        }
        if (this.firstOfBuffer) {
            this.firstOfBuffer = false;
            this.firstBufferedTime = now;
        }
        if (this.totalBufferedRecords >= MAX_RECORDS_NUMBER) {
            return true;
        }
        return now - this.firstBufferedTime >= OLD_RECORD_MAX_TIME_ELAPSED;
    }
}

