/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.util.Calendar;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;

public class BufferAggregationScheduler
extends AggregationScheduler {
    protected static final int MAX_RECORDS_NUMBER = 15;
    protected static final long OLD_RECORD_MAX_TIME_ELAPSED = 300000L;
    protected boolean firstOfBuffer = true;
    protected long firstBufferedTime;

    protected BufferAggregationScheduler() {
    }

    @Override
    protected void schedulerSpecificClear() {
        this.firstOfBuffer = true;
    }

    @Override
    public boolean isTimeToPersist() {
        long now = Calendar.getInstance().getTimeInMillis();
        if (this.firstOfBuffer) {
            this.firstOfBuffer = false;
            this.firstBufferedTime = now;
        }
        if (this.totalBufferedRecords >= 15) {
            return true;
        }
        return now - this.firstBufferedTime >= 300000L;
    }
}

