/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;

public class AggregationUtility<T extends AggregatedRecord<T, ?>> {
    protected T t;
    protected Set<String> aggregationFields;
    protected Set<String> neededFields;

    protected void setDefaultAggregationFields() {
        this.aggregationFields = new HashSet<String>(this.t.getRequiredFields());
        this.aggregationFields.removeAll(this.t.getAggregatedFields());
        this.aggregationFields.remove("id");
        this.aggregationFields.remove("creationTime");
        this.aggregationFields.remove("operationCount");
        this.aggregationFields.remove("aggregated");
        this.aggregationFields.remove("startTime");
        this.aggregationFields.remove("endTime");
    }

    protected void setDefaultNeededFields() {
        this.neededFields = new HashSet<String>(this.t.getRequiredFields());
        this.neededFields.addAll(this.t.getAggregatedFields());
        this.neededFields.add("operationCount");
        this.neededFields.add("aggregated");
        this.neededFields.add("startTime");
        this.neededFields.add("endTime");
    }

    public AggregationUtility(T t) {
        this.t = t;
        this.setDefaultAggregationFields();
        this.setDefaultNeededFields();
    }

    public void setAggregationFields(Set<String> aggregationFields) {
        this.aggregationFields = aggregationFields;
    }

    public void setNeededFields(Set<String> neededFields) {
        this.neededFields = neededFields;
    }

    public boolean isAggregable(T record) {
        for (String field : this.aggregationFields) {
            Comparable thisValueComparable;
            Comparable recordValueComparable;
            Serializable recordValue = record.getResourceProperty(field);
            Serializable thisValue = this.t.getResourceProperty(field);
            if (!(recordValue instanceof Comparable && thisValue instanceof Comparable ? (recordValueComparable = (Comparable)((Object)recordValue)).compareTo(thisValueComparable = (Comparable)((Object)thisValue)) != 0 : recordValue.hashCode() != this.hashCode())) continue;
            return false;
        }
        return true;
    }

    protected void cleanExtraFields() {
        Set<String> propertyKeys = this.t.getResourceProperties().keySet();
        for (String propertyName : propertyKeys) {
            if (this.neededFields.contains(propertyName)) continue;
            this.t.getResourceProperties().remove(propertyName);
        }
    }

    public synchronized T aggregate(T record) throws NotAggregatableRecordsExceptions {
        try {
            Calendar actualEndTime;
            Calendar recordEndTime;
            Calendar actualStartTime;
            if (!this.isAggregable(record)) {
                throw new NotAggregatableRecordsExceptions("The Record provided as argument has different values for field wich must be common to be aggregatable");
            }
            Calendar recordStartTime = record.getStartTime();
            if (recordStartTime.before(actualStartTime = this.t.getStartTime())) {
                this.t.setStartTime(recordStartTime);
            }
            if ((recordEndTime = record.getEndTime()).after(actualEndTime = this.t.getEndTime())) {
                this.t.setEndTime(recordEndTime);
            }
            Calendar newCreationTime = Calendar.getInstance();
            this.t.setCreationTime(newCreationTime);
            this.t.setOperationCount(this.t.getOperationCount() + record.getOperationCount());
            this.cleanExtraFields();
            return this.t;
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex.getCause());
        }
    }
}

