/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordUtility {
    private static Logger logger = LoggerFactory.getLogger(RecordUtility.class);
    private static final String LINE_FREFIX = "{";
    private static final String LINE_SUFFIX = "}";
    private static final String KEY_VALUE_PAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_LINKER = "=";
    protected static Map<String, Class<? extends Record>> recordClassesFound = new HashMap<String, Class<? extends Record>>();
    protected static Map<String, Class<? extends AggregatedRecord>> aggregatedRecordClassesFound = new HashMap<String, Class<? extends AggregatedRecord>>();

    public static Map<String, Class<? extends Record>> getRecordClassesFound() {
        return recordClassesFound;
    }

    public static Map<String, Class<? extends AggregatedRecord>> getAggregatedRecordClassesFound() {
        return aggregatedRecordClassesFound;
    }

    public static Class<? extends AggregatedRecord> getAggregatedRecordClass(String recordType) throws ClassNotFoundException {
        if (RecordUtility.getAggregatedRecordClassesFound().containsKey(recordType)) {
            return RecordUtility.getAggregatedRecordClassesFound().get(recordType);
        }
        logger.error("Unable to find {} class for {}.", (Object)AggregatedRecord.class.getSimpleName(), (Object)recordType);
        throw new ClassNotFoundException();
    }

    public static Class<? extends Record> getRecordClass(String recordType) throws ClassNotFoundException {
        if (recordClassesFound.containsKey(recordType)) {
            return recordClassesFound.get(recordType);
        }
        logger.error("Unable to find {} class for {}.", (Object)Record.class.getSimpleName(), (Object)recordType);
        throw new ClassNotFoundException();
    }

    protected static Class<? extends Record> getClass(String recordType, boolean aggregated) throws ClassNotFoundException {
        if (aggregated) {
            return RecordUtility.getAggregatedRecordClass(recordType);
        }
        return RecordUtility.getRecordClass(recordType);
    }

    protected static Map<String, ? extends Serializable> getMapFromString(String serializedMap) {
        if (!serializedMap.startsWith(LINE_FREFIX) && !serializedMap.endsWith(LINE_SUFFIX)) {
            return null;
        }
        serializedMap = serializedMap.replace(LINE_FREFIX, "");
        serializedMap = serializedMap.replace(LINE_SUFFIX, "");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = serializedMap.split(KEY_VALUE_PAIR_SEPARATOR);
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            pair.trim();
            String[] keyValue = pair.split(KEY_VALUE_LINKER);
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }

    public static Record getRecord(String serializedMap) throws Exception {
        Map<String, ? extends Serializable> map = RecordUtility.getMapFromString(serializedMap);
        return RecordUtility.getRecord(map);
    }

    public static Record getRecord(Map<String, ? extends Serializable> recordMap) throws Exception {
        String className = (String)((Object)recordMap.get("recordType"));
        boolean aggregated = false;
        try {
            aggregated = (Boolean)recordMap.get("aggregated");
        }
        catch (Exception e) {
            try {
                aggregated = Boolean.parseBoolean((String)((Object)recordMap.get("aggregated")));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        Class<? extends Record> clz = RecordUtility.getClass(className, aggregated);
        logger.debug("Trying to instantiate {}", clz);
        Class[] usageRecordArgTypes = new Class[]{Map.class};
        Constructor<? extends Record> usageRecordConstructor = clz.getDeclaredConstructor(usageRecordArgTypes);
        Object[] usageRecordArguments = new Object[]{recordMap};
        Record record = usageRecordConstructor.newInstance(usageRecordArguments);
        logger.debug("Created {} : {}", (Object)Record.class.getSimpleName(), (Object)record);
        return record;
    }

    static {
        Reflections recordClassesReflections = new Reflections(new Object[0]);
        Set recordClasses = recordClassesReflections.getSubTypesOf(Record.class);
        for (Class cls : recordClasses) {
            if (Modifier.isAbstract(cls.getModifiers())) continue;
            try {
                String discoveredRecordType;
                Record record = (Record)cls.newInstance();
                if (record instanceof AggregatedRecord || recordClassesFound.containsKey(discoveredRecordType = record.getRecordType())) continue;
                recordClassesFound.put(discoveredRecordType, cls);
            }
            catch (IllegalAccessException | InstantiationException e) {}
        }
        aggregatedRecordClassesFound = new HashMap<String, Class<? extends AggregatedRecord>>();
        Reflections aggregatedRecordReflections = new Reflections(new Object[0]);
        Set aggregatedRecordClasses = aggregatedRecordReflections.getSubTypesOf(AggregatedRecord.class);
        for (Class cls : aggregatedRecordClasses) {
            if (Modifier.isAbstract(cls.getModifiers())) continue;
            try {
                String discoveredRecordType = ((AggregatedRecord)cls.newInstance()).getRecordType();
                if (aggregatedRecordClassesFound.containsKey(discoveredRecordType)) continue;
                aggregatedRecordClassesFound.put(discoveredRecordType, cls);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("Unable to instantiate found {} class ({})", new Object[]{AggregatedRecord.class.getSimpleName(), cls.getSimpleName(), e});
            }
        }
    }
}

