/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceBackendMonitor;
import org.gcube.documentstore.persistence.PersistenceExecutor;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackend.class);
    protected FallbackPersistenceBackend fallbackPersistence;
    protected AggregationScheduler aggregationScheduler;
    protected PersistenceBackendMonitor persistenceBackendMonitor;
    private ExecutorService pool = Executors.newCachedThreadPool();

    protected PersistenceBackend() {
        if (!(this instanceof FallbackPersistenceBackend)) {
            this.persistenceBackendMonitor = new PersistenceBackendMonitor(this);
        }
    }

    protected PersistenceBackend(FallbackPersistenceBackend fallback, AggregationScheduler aggregationScheduler) {
        this();
        this.fallbackPersistence = fallback;
        this.aggregationScheduler = aggregationScheduler;
    }

    public FallbackPersistenceBackend getFallbackPersistence() {
        return this.fallbackPersistence;
    }

    protected void setFallback(FallbackPersistenceBackend fallback) {
        this.fallbackPersistence = fallback;
    }

    public AggregationScheduler getAggregationScheduler() {
        return this.aggregationScheduler;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(PersistenceBackendConfiguration var1) throws Exception;

    protected abstract void reallyAccount(Record var1) throws Exception;

    protected void accountWithFallback(Record ... records) {
        String persistenceName = this.getClass().getSimpleName();
        logger.trace("Going to account {} using {} : {}", new Object[]{Arrays.toString(records), persistenceName, this});
        for (Record record : records) {
            try {
                logger.trace("Going to account {} using {} : {}", new Object[]{record, persistenceName, this});
                this.reallyAccount(record);
                logger.debug("{} accounted succesfully from {}.", (Object)record.toString(), (Object)persistenceName);
            }
            catch (Exception e) {
                try {
                    String fallabackPersistenceName = FallbackPersistenceBackend.class.getSimpleName();
                    logger.error("{} was not accounted succesfully from {}. Trying to use {}.", new Object[]{record.toString(), persistenceName, fallabackPersistenceName, e});
                    this.fallbackPersistence.reallyAccount(record);
                    logger.debug("{} accounted succesfully from {}", (Object)record.toString(), (Object)fallabackPersistenceName);
                }
                catch (Exception ex) {
                    logger.error("{} was not accounted at all", (Object)record.toString(), (Object)e);
                }
            }
        }
    }

    protected void accountValidateAggregate(Record record, boolean validate, boolean aggregate) {
        try {
            logger.debug("Received {} to account : {}", (Object)record.getClass().getSimpleName(), (Object)record);
            if (validate) {
                record.validate();
                logger.trace("{} {} valid", (Object)record.getClass().getSimpleName(), (Object)record);
            }
            if (aggregate) {
                final PersistenceBackend persistence = this;
                this.aggregationScheduler.aggregate(record, new PersistenceExecutor(){

                    @Override
                    public void persist(Record ... records) throws Exception {
                        persistence.accountWithFallback(records);
                    }
                });
            } else {
                this.accountWithFallback(record);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Error recording {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
    }

    public void account(final Record record) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PersistenceBackend.this.accountValidateAggregate(record, true, true);
            }
        };
        this.pool.execute(runnable);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        this.pool.awaitTermination(timeout, timeUnit);
        final PersistenceBackend persistence = this;
        this.aggregationScheduler.flush(new PersistenceExecutor(){

            @Override
            public void persist(Record ... records) throws Exception {
                persistence.accountWithFallback(records);
            }
        });
    }

    public abstract void close() throws Exception;
}

