/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.sql.Statement;
import org.gcube.accounting.utility.postgresql.PostgreSQLQuery;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.StatementMap;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistencePostgreSQL
extends PersistenceBackend {
    protected static final Logger logger = LoggerFactory.getLogger(PersistencePostgreSQL.class);
    protected StatementMap statementMap;

    public void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        this.statementMap = new StatementMap(configuration);
    }

    protected void openConnection() throws Exception {
    }

    protected void reallyAccount(Record record) throws Exception {
        Statement statement = this.statementMap.getStatement(record);
        PostgreSQLQuery postgreSQLQuery = new PostgreSQLQuery();
        String sqlCommand = postgreSQLQuery.getSQLInsertCommand(record);
        statement.executeUpdate(sqlCommand);
    }

    public void insert(Record record) throws Exception {
        this.reallyAccount(record);
    }

    protected void clean() throws Exception {
        this.statementMap.close();
    }

    protected void closeConnection() throws Exception {
        this.statementMap.close();
    }

    public void commitAndClose() throws Exception {
        this.statementMap.close();
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }
}

