/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class EnumCodec<E extends Enum<E>>
implements Codec<E> {
    protected final Class<E> eClass;

    public EnumCodec(Class<E> eClass) {
        this.eClass = eClass;
    }

    public void encode(BsonWriter writer, E e, EncoderContext ec) {
        writer.writeString(((Enum)e).name());
    }

    public Class<E> getEncoderClass() {
        return this.eClass;
    }

    public E decode(BsonReader reader, DecoderContext dc) {
        String enumString = reader.readString();
        return Enum.valueOf(this.getEncoderClass(), enumString);
    }
}

