/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.gcube.documentstore.persistence.EnumCodec;
import org.gcube.documentstore.persistence.GenericCodec;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceMongoDB
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceMongoDB.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String USERNAME_PROPERTY_KEY = "username";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String DB_NAME = "dbName";
    public static final String COLLECTION_NAME = "collectionName";
    protected String collectionName;
    protected static final ReadPreference READ_PREFERENCE = ReadPreference.secondaryPreferred();
    protected static final MongoClientOptions MONGO_CLIENT_OPTIONS;
    protected PersistenceBackendConfiguration configuration;
    protected MongoClient mongoClient;
    protected MongoClientOptions mongoClientOptions = MONGO_CLIENT_OPTIONS;
    protected MongoDatabase mongoDatabase;

    public static CodecRegistry addCoded(CodecRegistry cr, Codec<?>[] codecs) {
        CodecRegistry crFromCodes = CodecRegistries.fromCodecs(codecs);
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{cr, crFromCodes});
    }

    protected static MongoClientOptions createMongoClientOptions(CodecRegistry cr) {
        return MongoClientOptions.builder().codecRegistry(cr).build();
    }

    public void openConnection() throws Exception {
    }

    protected void closeConnection() throws Exception {
    }

    public void close() throws Exception {
        this.mongoClient.close();
    }

    public static List<? extends Codec<?>> discoverAdditionalCodecs() {
        ArrayList<Object> codecs = new ArrayList<Object>();
        HashSet enumClasses = new HashSet();
        Reflections recordClassesReflections = new Reflections(new Object[0]);
        Set recordClasses = recordClassesReflections.getSubTypesOf(Record.class);
        Iterator i$ = recordClasses.iterator();
        while (i$.hasNext()) {
            Class clazz;
            for (Class auxClass = clazz = (Class)i$.next(); auxClass != null; auxClass = auxClass.getSuperclass()) {
                Class<?>[] classes;
                for (Class<?> clz : classes = auxClass.getClasses()) {
                    if (!clz.isEnum() || enumClasses.contains(clz)) continue;
                    logger.trace("Found Enum {}", clz);
                    enumClasses.add(clz);
                }
            }
        }
        logger.trace("Found Enums : {}", enumClasses);
        for (Class clazz : enumClasses) {
            EnumCodec enumCodec = new EnumCodec(clazz);
            codecs.add(enumCodec);
        }
        GenericCodec<URI> uriCodec = new GenericCodec<URI>(URI.class);
        codecs.add(uriCodec);
        return codecs;
    }

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        this.configuration = configuration;
        String completeURL = configuration.getProperty(URL_PROPERTY_KEY);
        String username = configuration.getProperty(USERNAME_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        String dbName = configuration.getProperty(DB_NAME);
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)username, (String)dbName, (char[])password.toCharArray());
        String[] urls = completeURL.split(";");
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        for (String url : urls) {
            url = url.startsWith("http://") ? url.replace("http://", "") : url;
            url = url.startsWith("https://") ? url.replace("https://", "") : url;
            ServerAddress serverAddress = new ServerAddress(url);
            serverAddresses.add(serverAddress);
        }
        this.mongoClient = new MongoClient(serverAddresses, Arrays.asList(credential), this.mongoClientOptions);
        this.mongoDatabase = this.mongoClient.getDatabase(dbName);
        this.collectionName = configuration.getProperty(COLLECTION_NAME);
        if (this.mongoDatabase.getCollection(this.collectionName) == null) {
            this.mongoDatabase.createCollection(this.collectionName);
        }
    }

    protected void createItem(Document document) throws Exception {
        this.mongoDatabase.getCollection(this.collectionName).insertOne((Object)document);
    }

    protected static List<Codec> findMissingCodecs(CodecRegistry cr, Record record) {
        ArrayList<Codec> codecs = new ArrayList<Codec>();
        Collection properties = record.getResourceProperties().values();
        for (Serializable value : properties) {
            try {
                try {
                    cr.get(value.getClass());
                    logger.trace("Codec found for {} : {}", value.getClass(), (Object)value);
                }
                catch (CodecConfigurationException cce) {
                    logger.trace("No Codec found for {} : {}", value.getClass(), (Object)value);
                    if (value.getClass().isEnum()) {
                        EnumCodec enumCodec = new EnumCodec(value.getClass());
                        codecs.add(enumCodec);
                        logger.trace("Adding {} to manage {} : {}", new Object[]{enumCodec, value.getClass(), value});
                        continue;
                    }
                    GenericCodec genericCodec = new GenericCodec(value.getClass());
                    try {
                        Object recreatedValue = genericCodec.getFromString(value.toString());
                        if (value instanceof Comparable && recreatedValue instanceof Comparable) {
                            Comparable valueComparable = (Comparable)((Object)value);
                            Comparable recreatedValueComparable = (Comparable)recreatedValue;
                            if (valueComparable.compareTo(recreatedValueComparable) != 0) continue;
                            codecs.add(genericCodec);
                            logger.trace("Adding {} to manage {} : {}", new Object[]{genericCodec, value.getClass(), value});
                            continue;
                        }
                        if (value.hashCode() == recreatedValue.hashCode()) {
                            codecs.add(genericCodec);
                            logger.trace("Adding {} to manage {} : {}", new Object[]{genericCodec, value.getClass(), value});
                            continue;
                        }
                        String message = String.format("%s != %s", value, recreatedValue);
                        throw new Exception(message);
                    }
                    catch (Exception e) {
                        logger.error("{} cannot be used for {} : {}", new Object[]{GenericCodec.class.getSimpleName(), value.getClass(), value, e});
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Error evaluating if {} can be serialized as bson Object", (Object)value, (Object)ex);
            }
        }
        return codecs;
    }

    protected void checkSerializability(Record record) throws Exception {
        CodecRegistry cr = this.mongoClientOptions.getCodecRegistry();
        List<Codec> codecs = PersistenceMongoDB.findMissingCodecs(cr, record);
        if (!codecs.isEmpty()) {
            logger.debug("Recreating Mongo CLient to Add Codecs");
            Codec[] codecArray = new Codec[codecs.size()];
            codecArray = codecs.toArray(codecArray);
            CodecRegistry newCR = PersistenceMongoDB.addCoded(cr, codecArray);
            this.mongoClientOptions = PersistenceMongoDB.createMongoClientOptions(newCR);
            this.mongoClient.close();
            this.prepareConnection(this.configuration);
        }
    }

    protected void reallyAccount(Record record) throws Exception {
        this.checkSerializability(record);
        Document document = PersistenceMongoDB.usageRecordToDocument(record);
        this.createItem(document);
    }

    public static Document usageRecordToDocument(Record record) throws Exception {
        Document document = new Document();
        document.putAll(record.getResourceProperties());
        return document;
    }

    protected static Record documentToUsageRecord(Document document) throws Exception {
        HashMap map = new HashMap();
        Set set = document.entrySet();
        for (Map.Entry entry : set) {
            Serializable value = (Serializable)entry.getValue();
            map.put(entry.getKey(), value);
        }
        Record record = RecordUtility.getRecord(map);
        return record;
    }

    protected void clean() throws Exception {
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }

    static {
        List<Codec<?>> additionalCodecs = PersistenceMongoDB.discoverAdditionalCodecs();
        CodecRegistry mongoDefaultCR = MongoClient.getDefaultCodecRegistry();
        Codec[] codecArray = new Codec[additionalCodecs.size()];
        codecArray = additionalCodecs.toArray(codecArray);
        CodecRegistry cr = PersistenceMongoDB.addCoded(mongoDefaultCR, codecArray);
        MONGO_CLIENT_OPTIONS = PersistenceMongoDB.createMongoClientOptions(cr);
    }
}

