/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class GenericCodec<T extends Serializable>
implements Codec<T> {
    protected final Class<T> tClass;

    public GenericCodec(Class<T> tClass) {
        this.tClass = tClass;
    }

    public void encode(BsonWriter writer, T t, EncoderContext ec) {
        writer.writeString(t.toString());
    }

    public Class<T> getEncoderClass() {
        return this.tClass;
    }

    public T getFromString(String stringRepresentation) throws Exception {
        Class[] argTypes = new Class[]{String.class};
        Constructor<T> constructor = this.getEncoderClass().getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{stringRepresentation};
        return (T)((Serializable)constructor.newInstance(arguments));
    }

    public T decode(BsonReader reader, DecoderContext dc) {
        String stringRepresentation = reader.readString();
        try {
            return this.getFromString(stringRepresentation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

