/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class PhraseQuery
extends SearchQuery {
    private final String[] terms;
    private final String field;

    protected PhraseQuery(Builder builder) {
        super(builder);
        this.terms = builder.terms;
        this.field = builder.field;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String[] terms() {
        return this.terms;
    }

    public String field() {
        return this.field;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("terms", JsonArray.from(this.terms)).put("field", this.field);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String[] terms;
        private String field;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public PhraseQuery build() {
            return new PhraseQuery(this);
        }

        public Builder terms(String ... terms) {
            this.terms = terms;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }
    }
}

