/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class MatchPhraseQuery
extends SearchQuery {
    private final String matchPhrase;
    private final String field;
    private final String analyzer;

    protected MatchPhraseQuery(Builder builder) {
        super(builder);
        this.matchPhrase = builder.matchPhrase;
        this.field = builder.field;
        this.analyzer = builder.analyzer;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String match() {
        return this.matchPhrase;
    }

    public String field() {
        return this.field;
    }

    public String analyzer() {
        return this.analyzer;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("match_phrase", this.matchPhrase).put("field", this.field).put("analyzer", this.analyzer);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String matchPhrase;
        private String field;
        private String analyzer;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public MatchPhraseQuery build() {
            return new MatchPhraseQuery(this);
        }

        public Builder matchPhrase(String matchPhrase) {
            this.matchPhrase = matchPhrase;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }
    }
}

